/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.psystem.basicenumerables;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.psystem.ITypeInfoProviderConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.KeyedEnumerablePConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PSystem;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherContext;
import org.eclipse.incquery.runtime.rete.tuple.FlatTuple;

public class TypeBinary<PatternDescription, StubHandle>
extends KeyedEnumerablePConstraint<Object, PatternDescription, StubHandle>
implements ITypeInfoProviderConstraint {
    private final IPatternMatcherContext<PatternDescription> context;
    private PVariable source;
    private PVariable target;

    public TypeBinary(PSystem<PatternDescription, StubHandle, ?> pSystem, IPatternMatcherContext<PatternDescription> context, PVariable source, PVariable target, Object typeKey) {
        super(pSystem, new FlatTuple(source, target), typeKey);
        this.source = source;
        this.target = target;
        this.context = context;
    }

    @Override
    public Stub<StubHandle> doCreateStub() {
        return this.buildable.binaryEdgeTypeStub(this.variablesTuple, this.supplierKey);
    }

    @Override
    public Object getTypeInfo(PVariable variable) {
        if (variable.equals(this.variablesTuple.get(0))) {
            return this.context.binaryEdgeSourceType(this.supplierKey);
        }
        if (variable.equals(this.variablesTuple.get(1))) {
            return this.context.binaryEdgeTargetType(this.supplierKey);
        }
        return ITypeInfoProviderConstraint.TypeInfoSpecials.NO_TYPE_INFO_PROVIDED;
    }

    @Override
    protected String keyToString() {
        return this.pSystem.getContext().printType(this.supplierKey);
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies() {
        HashMap<Set<PVariable>, Set<PVariable>> result = new HashMap<Set<PVariable>, Set<PVariable>>();
        if (this.context.isBinaryEdgeMultiplicityToOne(this.supplierKey)) {
            result.put(Collections.singleton(this.source), Collections.singleton(this.target));
        }
        if (this.context.isBinaryEdgeMultiplicityOneTo(this.supplierKey)) {
            result.put(Collections.singleton(this.target), Collections.singleton(this.source));
        }
        return result;
    }
}

