/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred;

import java.util.Collections;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.psystem.PSystem;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.construction.psystem.VariableDeferredPConstraint;

public class ExportedParameter<PatternDescription, StubHandle>
extends VariableDeferredPConstraint<PatternDescription, StubHandle> {
    PVariable parameterVariable;
    Object parameterName;

    public ExportedParameter(PSystem<PatternDescription, StubHandle, ?> pSystem, PVariable parameterVariable, String parameterName) {
        super(pSystem, Collections.singleton(parameterVariable));
        this.parameterVariable = parameterVariable;
        this.parameterName = parameterVariable.getName();
    }

    @Override
    public void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (obsolete.equals(this.parameterVariable)) {
            this.parameterVariable = replacement;
        }
    }

    @Override
    protected String toStringRest() {
        Object varName = this.parameterVariable.getName();
        return this.parameterName.equals(varName) ? this.parameterName.toString() : this.parameterName + "(" + varName + ")";
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return Collections.emptySet();
    }

    public Object getParameterName() {
        return this.parameterName;
    }

    public PVariable getParameterVariable() {
        return this.parameterVariable;
    }

    @Override
    protected Set<PVariable> getDeferringVariables() {
        return Collections.singleton(this.parameterVariable);
    }

    @Override
    protected Stub<StubHandle> doCheckOn(Stub<StubHandle> stub) throws RetePatternBuildException {
        return stub;
    }

    @Override
    public void checkSanity() throws RetePatternBuildException {
        super.checkSanity();
        if (!this.parameterVariable.isDeducable()) {
            String[] args = new String[]{this.parameterName.toString()};
            String msg = "Impossible to match pattern: exported pattern variable {1} can not be determined based on the pattern constraints. HINT: certain constructs (e.g. negative patterns or check expressions) cannot output symbolic parameters.";
            String shortMsg = "Could not deduce value of parameter";
            throw new RetePatternBuildException(msg, args, shortMsg, null);
        }
    }

    @Override
    public void raiseForeverDeferredError(Stub<StubHandle> stub) throws RetePatternBuildException {
        String[] args = new String[]{this.parameterName.toString()};
        String msg = "Pattern Graph Search terminated incompletely: exported pattern variable {1} could not be determined based on the pattern constraints. HINT: certain constructs (e.g. negative patterns or check expressions) cannot output symbolic parameters.";
        String shortMsg = "Could not deduce value of parameter";
        throw new RetePatternBuildException(msg, args, shortMsg, null);
    }
}

