/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class PBody {
    private PQuery query;
    private PQuery.PQueryStatus status = PQuery.PQueryStatus.UNINITIALIZED;
    private Set<PVariable> allVariables;
    private Set<PVariable> uniqueVariables;
    private List<ExportedParameter> symbolicParameters;
    private Map<Object, PVariable> variablesByName;
    private Set<PConstraint> constraints;
    private int nextVirtualNodeID;

    public PBody(PQuery query) {
        this.query = query;
        this.allVariables = new LinkedHashSet<PVariable>();
        this.uniqueVariables = new LinkedHashSet<PVariable>();
        this.variablesByName = new HashMap<Object, PVariable>();
        this.constraints = new LinkedHashSet<PConstraint>();
    }

    private boolean addVariable(PVariable var) {
        this.checkMutability();
        String name = var.getName();
        if (!this.variablesByName.containsKey(name)) {
            this.allVariables.add(var);
            if (var.isUnique()) {
                this.uniqueVariables.add(var);
            }
            this.variablesByName.put(name, var);
            return true;
        }
        return false;
    }

    boolean registerConstraint(PConstraint constraint) {
        this.checkMutability();
        return this.constraints.add(constraint);
    }

    boolean unregisterConstraint(PConstraint constraint) {
        this.checkMutability();
        return this.constraints.remove(constraint);
    }

    public <ConstraintType> Set<ConstraintType> getConstraintsOfType(Class<ConstraintType> constraintClass) {
        HashSet<PConstraint> result = new HashSet<PConstraint>();
        for (PConstraint pConstraint : this.constraints) {
            if (!constraintClass.isInstance(pConstraint)) continue;
            result.add(pConstraint);
        }
        return result;
    }

    public PVariable newVirtualVariable() {
        String name;
        this.checkMutability();
        while (this.variablesByName.containsKey(name = String.format(".virtual{%d}", this.nextVirtualNodeID++))) {
        }
        PVariable var = new PVariable(this, name, true);
        this.addVariable(var);
        return var;
    }

    public PVariable newConstantVariable(Object value) {
        this.checkMutability();
        PVariable virtual = this.newVirtualVariable();
        new ConstantValue(this, virtual, value);
        return virtual;
    }

    public Set<PVariable> getAllVariables() {
        return this.allVariables;
    }

    public Set<PVariable> getUniqueVariables() {
        return this.uniqueVariables;
    }

    private PVariable getVariableByName(Object name) {
        return this.variablesByName.get(name).getUnifiedIntoRoot();
    }

    public PVariable getVariableByNameChecked(Object name) throws IllegalArgumentException {
        if (!this.variablesByName.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Cannot find PVariable %s", name));
        }
        return this.getVariableByName(name);
    }

    public PVariable getOrCreateVariableByName(String name) {
        this.checkMutability();
        if (!this.variablesByName.containsKey(name)) {
            this.addVariable(new PVariable(this, name));
        }
        return this.getVariableByName(name);
    }

    public Set<PConstraint> getConstraints() {
        return this.constraints;
    }

    public PQuery getPattern() {
        return this.query;
    }

    void noLongerUnique(PVariable pVariable) {
        assert (!pVariable.isUnique());
        this.uniqueVariables.remove(pVariable);
    }

    public List<PVariable> getSymbolicParameterVariables() {
        return Lists.transform(this.symbolicParameters, (Function)new Function<ExportedParameter, PVariable>(){

            public PVariable apply(ExportedParameter constraint) {
                return constraint.getParameterVariable();
            }
        });
    }

    public List<ExportedParameter> getSymbolicParameters() {
        return this.symbolicParameters == null ? Lists.newArrayList() : this.symbolicParameters;
    }

    public void setExportedParameters(List<ExportedParameter> symbolicParameters) {
        this.checkMutability();
        this.symbolicParameters = Lists.newArrayList(symbolicParameters);
    }

    public void setStatus(PQuery.PQueryStatus status) {
        this.status = status;
    }

    public boolean isMutable() {
        if (this.status == null) {
            return this.query.isMutable();
        }
        return this.status.equals((Object)PQuery.PQueryStatus.UNINITIALIZED);
    }

    void checkMutability() throws IllegalStateException {
        if (this.status == null) {
            this.query.checkMutability();
        } else {
            Preconditions.checkState((boolean)this.status.equals((Object)PQuery.PQueryStatus.UNINITIALIZED));
        }
    }
}

