/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.planning.helpers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.psystem.ITypeInfoProviderConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;

public class TypeHelper {
    public static Set<Object> inferTypes(PVariable pVariable, Set<PConstraint> constraints) {
        HashSet<Object> inferredTypes = new HashSet<Object>();
        for (PConstraint pConstraint : constraints) {
            Object typeInfo;
            if (!(pConstraint instanceof ITypeInfoProviderConstraint) || (typeInfo = ((ITypeInfoProviderConstraint)((Object)pConstraint)).getTypeInfo(pVariable)) == ITypeInfoProviderConstraint.TypeInfoSpecials.NO_TYPE_INFO_PROVIDED) continue;
            inferredTypes.add(typeInfo);
        }
        return inferredTypes;
    }

    public static Set<Object> typeClosure(Set<Object> typesToClose, IPatternMatcherContext context) {
        HashSet<Object> closure;
        HashSet<Object> delta = closure = new HashSet<Object>(typesToClose);
        while (!delta.isEmpty()) {
            HashSet<Object> newTypes = new HashSet<Object>();
            for (Object e : delta) {
                Collection<? extends Object> directSupertypes;
                if (e instanceof ITypeInfoProviderConstraint.TypeInfoSpecials) continue;
                if (context.isUnaryType(e)) {
                    newTypes.add((Object)ITypeInfoProviderConstraint.TypeInfoSpecials.ANY_UNARY);
                }
                if (context.isTernaryEdgeType(e)) {
                    newTypes.add((Object)ITypeInfoProviderConstraint.TypeInfoSpecials.ANY_TERNARY);
                }
                if ((directSupertypes = context.enumerateDirectSupertypes(e)) == null) continue;
                newTypes.addAll(directSupertypes);
            }
            newTypes.removeAll(closure);
            delta = newTypes;
            closure.addAll(delta);
        }
        return closure;
    }

    public static Set<Object> subsumeTypes(Set<Object> subsumableTypes, Set<Object> subsumingTypes, IPatternMatcherContext context) {
        Set<Object> closure = TypeHelper.typeClosure(subsumingTypes, context);
        HashSet<Object> subsumed = new HashSet<Object>(subsumableTypes);
        subsumed.removeAll(closure);
        return subsumed;
    }
}

