/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.api;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.evm.api.ExecutionSchema;
import org.eclipse.incquery.runtime.evm.api.Executor;
import org.eclipse.incquery.runtime.evm.api.RuleBase;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.api.event.EventRealm;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.RuleEngines;

public final class EventDrivenVM {
    private EventDrivenVM() {
    }

    public static RuleEngine createRuleEngine(EventRealm eventRealm) {
        RuleBase ruleBase = new RuleBase(eventRealm);
        return RuleEngine.create(ruleBase);
    }

    public static ExecutionSchema createExecutionSchema(EventRealm eventRealm, Scheduler.ISchedulerFactory schedulerFactory, Set<RuleSpecification<?>> specifications) {
        Preconditions.checkNotNull((Object)schedulerFactory, (Object)"Cannot create execution schema with null scheduler factory");
        Preconditions.checkNotNull(specifications, (Object)"Cannot create execution schema with null rule specification set");
        Executor executor = new Executor(eventRealm);
        RuleBase ruleBase = executor.getRuleBase();
        for (RuleSpecification<?> specification : specifications) {
            EventDrivenVM.instantiateRuleInRuleBase(ruleBase, specification);
        }
        Scheduler scheduler = schedulerFactory.prepareScheduler(executor);
        return ExecutionSchema.create(scheduler);
    }

    private static <EventAtom> void instantiateRuleInRuleBase(RuleBase ruleBase, RuleSpecification<EventAtom> specification) {
        EventFilter<EventAtom> emptyFilter = specification.createEmptyFilter();
        ruleBase.instantiateRule(specification, emptyFilter);
    }

    public static ExecutionSchema createIncQueryExecutionSchema(IncQueryEngine engine, Scheduler.ISchedulerFactory schedulerFactory, Set<RuleSpecification<?>> specifications) {
        return ExecutionSchemas.createIncQueryExecutionSchema(engine, schedulerFactory, specifications);
    }

    public static ExecutionSchema createIncQueryExecutionSchema(IncQueryEngine engine, Scheduler.ISchedulerFactory schedulerFactory) {
        return ExecutionSchemas.createIncQueryExecutionSchema(engine, schedulerFactory);
    }

    public static RuleEngine createIncQueryRuleEngine(IncQueryEngine engine) {
        return RuleEngines.createIncQueryRuleEngine(engine);
    }

    public static RuleEngine createIncQueryRuleEngine(IncQueryEngine engine, Set<RuleSpecification<?>> specifications) {
        return RuleEngines.createIncQueryRuleEngine(engine, specifications);
    }
}

