package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.util.MessageMessageKindQuerySpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageKind;

/**
 * Pattern-specific match representation of the org.eclipse.incquery.uml.derivedfeatures.messageMessageKind pattern,
 * to be used in conjunction with {@link MessageMessageKindMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see MessageMessageKindMatcher
 * @see MessageMessageKindProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class MessageMessageKindMatch extends BasePatternMatch {
  private Message fSelf;
  
  private MessageKind fMessageKind;
  
  private static List<String> parameterNames = makeImmutableList("self", "messageKind");
  
  private MessageMessageKindMatch(final Message pSelf, final MessageKind pMessageKind) {
    this.fSelf = pSelf;
    this.fMessageKind = pMessageKind;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("self".equals(parameterName)) return this.fSelf;
    if ("messageKind".equals(parameterName)) return this.fMessageKind;
    return null;
  }
  
  public Message getSelf() {
    return this.fSelf;
  }
  
  public MessageKind getMessageKind() {
    return this.fMessageKind;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("self".equals(parameterName) ) {
    	this.fSelf = (Message) newValue;
    	return true;
    }
    if ("messageKind".equals(parameterName) ) {
    	this.fMessageKind = (MessageKind) newValue;
    	return true;
    }
    return false;
  }
  
  public void setSelf(final Message pSelf) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fSelf = pSelf;
  }
  
  public void setMessageKind(final MessageKind pMessageKind) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fMessageKind = pMessageKind;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.incquery.uml.derivedfeatures.messageMessageKind";
  }
  
  @Override
  public List<String> parameterNames() {
    return MessageMessageKindMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fSelf, fMessageKind};
  }
  
  @Override
  public MessageMessageKindMatch toImmutable() {
    return isMutable() ? newMatch(fSelf, fMessageKind) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"self\"=" + prettyPrintValue(fSelf) + ", ");
    
    result.append("\"messageKind\"=" + prettyPrintValue(fMessageKind)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fSelf == null) ? 0 : fSelf.hashCode());
    result = prime * result + ((fMessageKind == null) ? 0 : fMessageKind.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof MessageMessageKindMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    MessageMessageKindMatch other = (MessageMessageKindMatch) obj;
    if (fSelf == null) {if (other.fSelf != null) return false;}
    else if (!fSelf.equals(other.fSelf)) return false;
    if (fMessageKind == null) {if (other.fMessageKind != null) return false;}
    else if (!fMessageKind.equals(other.fMessageKind)) return false;
    return true;
  }
  
  @Override
  public MessageMessageKindQuerySpecification specification() {
    try {
    	return MessageMessageKindQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static MessageMessageKindMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pMessageKind the fixed value of pattern parameter messageKind, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static MessageMessageKindMatch newMutableMatch(final Message pSelf, final MessageKind pMessageKind) {
    return new Mutable(pSelf, pMessageKind);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pMessageKind the fixed value of pattern parameter messageKind, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static MessageMessageKindMatch newMatch(final Message pSelf, final MessageKind pMessageKind) {
    return new Immutable(pSelf, pMessageKind);
  }
  
  private static final class Mutable extends MessageMessageKindMatch {
    Mutable(final Message pSelf, final MessageKind pMessageKind) {
      super(pSelf, pMessageKind);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends MessageMessageKindMatch {
    Immutable(final Message pSelf, final MessageKind pMessageKind) {
      super(pSelf, pMessageKind);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
