package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.DeploymentTargetDeployedElementMatch;
import org.eclipse.incquery.uml.derivedfeatures.DeploymentTargetDeployedElementMatcher;

/**
 * A pattern-specific query specification that can instantiate DeploymentTargetDeployedElementMatcher in a type-safe way.
 * 
 * @see DeploymentTargetDeployedElementMatcher
 * @see DeploymentTargetDeployedElementMatch
 * 
 */
@SuppressWarnings("all")
public final class DeploymentTargetDeployedElementQuerySpecification extends BaseGeneratedEMFQuerySpecification<DeploymentTargetDeployedElementMatcher> {
  private DeploymentTargetDeployedElementQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static DeploymentTargetDeployedElementQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected DeploymentTargetDeployedElementMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return DeploymentTargetDeployedElementMatcher.on(engine);
  }
  
  @Override
  public DeploymentTargetDeployedElementMatch newEmptyMatch() {
    return DeploymentTargetDeployedElementMatch.newEmptyMatch();
  }
  
  @Override
  public DeploymentTargetDeployedElementMatch newMatch(final Object... parameters) {
    return DeploymentTargetDeployedElementMatch.newMatch((org.eclipse.uml2.uml.DeploymentTarget) parameters[0], (org.eclipse.uml2.uml.PackageableElement) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static DeploymentTargetDeployedElementQuerySpecification INSTANCE = make();
    
    public static DeploymentTargetDeployedElementQuerySpecification make() {
      return new DeploymentTargetDeployedElementQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static DeploymentTargetDeployedElementQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.deploymentTargetDeployedElement";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","packageableElement");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.DeploymentTarget"),new PParameter("packageableElement", "org.eclipse.uml2.uml.PackageableElement"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_self = body.getOrCreateVariableByName("self");
      	PVariable var_packageableElement = body.getOrCreateVariableByName("packageableElement");
      	PVariable var_artifact = body.getOrCreateVariableByName("artifact");
      	PVariable var_temp2 = body.getOrCreateVariableByName("temp2");
      	PVariable var_deployment = body.getOrCreateVariableByName("deployment");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var_temp1 = body.getOrCreateVariableByName("temp1");
      	PVariable var_deployedArtifact = body.getOrCreateVariableByName("deployedArtifact");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	PVariable var_temp3 = body.getOrCreateVariableByName("temp3");
      	PVariable var_manifestation = body.getOrCreateVariableByName("manifestation");
      	PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      	PVariable var_temp4 = body.getOrCreateVariableByName("temp4");
      	PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_self, "self"),
      				
      		new ExportedParameter(body, var_packageableElement, "packageableElement")
      	));
      	new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "DeploymentTarget")));
      	new TypeConstraint(body, new FlatTuple(var_packageableElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageableElement")));
      	new TypeConstraint(body, new FlatTuple(var_artifact), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Artifact")));
      	new Equality(body, var_temp2, var_artifact);
      	new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "DeploymentTarget")));
      	new TypeConstraint(body, new FlatTuple(var_self, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "DeploymentTarget", "deployment")));
      	new Equality(body, var__virtual_0_, var_deployment);
      	new Equality(body, var_temp1, var_deployment);
      	new TypeConstraint(body, new FlatTuple(var_temp1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Deployment")));
      	new TypeConstraint(body, new FlatTuple(var_temp1, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Deployment", "deployedArtifact")));
      	new Equality(body, var__virtual_1_, var_deployedArtifact);
      	new Equality(body, var_temp2, var_deployedArtifact);
      	new Equality(body, var_temp3, var_temp2);
      	new TypeConstraint(body, new FlatTuple(var_temp3), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Artifact")));
      	new TypeConstraint(body, new FlatTuple(var_temp3, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Artifact", "manifestation")));
      	new Equality(body, var__virtual_2_, var_manifestation);
      	new Equality(body, var_temp4, var_manifestation);
      	new TypeConstraint(body, new FlatTuple(var_temp4), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Manifestation")));
      	new TypeConstraint(body, new FlatTuple(var_temp4, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Manifestation", "utilizedElement")));
      	new Equality(body, var__virtual_3_, var_packageableElement);
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "deployedElement");
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
