/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.emf;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.scope.IEngineContext;
import org.eclipse.incquery.runtime.api.scope.IIndexingErrorListener;
import org.eclipse.incquery.runtime.api.scope.IncQueryScope;
import org.eclipse.incquery.runtime.base.api.BaseIndexOptions;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.emf.EMFBaseIndexWrapper;
import org.eclipse.incquery.runtime.emf.EMFEngineContext;
import org.eclipse.incquery.runtime.exception.IncQueryException;

public class EMFScope
extends IncQueryScope {
    Notifier scopeRoot;
    BaseIndexOptions options;

    public EMFScope(Notifier scopeRoot) throws IncQueryException {
        this(scopeRoot, new BaseIndexOptions());
    }

    public EMFScope(Notifier scopeRoot, BaseIndexOptions options) throws IncQueryException {
        this.scopeRoot = scopeRoot;
        this.options = options.copy();
        if (!(scopeRoot instanceof EObject || scopeRoot instanceof Resource || scopeRoot instanceof ResourceSet)) {
            throw new IncQueryException("Incremental EMF query engine can only be attached on the contents of an EMF EObject, Resource, or ResourceSet. Received instead: " + (scopeRoot == null ? "(null)" : scopeRoot.getClass().getName()), "Invalid EMF model root");
        }
    }

    public static NavigationHelper extractUnderlyingEMFIndex(IncQueryEngine engine) throws IncQueryException {
        IncQueryScope scope = engine.getScope();
        if (scope instanceof EMFScope) {
            return ((EMFBaseIndexWrapper)AdvancedIncQueryEngine.from(engine).getBaseIndex()).getNavigationHelper();
        }
        throw new IllegalArgumentException("Cannot extract EMF base index from IncQuery engine instantiated on non-EMF scope " + scope);
    }

    public Notifier getScopeRoot() {
        return this.scopeRoot;
    }

    public BaseIndexOptions getOptions() {
        return this.options.copy();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        result = 31 * result + (this.scopeRoot == null ? 0 : this.scopeRoot.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EMFScope)) {
            return false;
        }
        EMFScope other = (EMFScope)obj;
        if (this.options == null ? other.options != null : !this.options.equals((Object)other.options)) {
            return false;
        }
        return !(this.scopeRoot == null ? other.scopeRoot != null : !this.scopeRoot.equals(other.scopeRoot));
    }

    public String toString() {
        return String.format("EMFScope(%s):%s", this.options, this.scopeRoot);
    }

    @Override
    protected IEngineContext createEngineContext(IncQueryEngine engine, IIndexingErrorListener errorListener, Logger logger) {
        return new EMFEngineContext(this, engine, errorListener, logger);
    }
}

