/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model.converters;

import com.google.common.base.Preconditions;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.viewers.runtime.model.FormatSpecification;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.converters.FormatParser;

public class ItemConverter
implements IConverter {
    private String parameterName;
    private String labelParameterName;
    private Item.HierarchyPolicy policy;
    private FormatSpecification format;

    public ItemConverter(Annotation itemAnnotation, Annotation formatAnnotation) {
        Preconditions.checkArgument((boolean)"Item".equals(itemAnnotation.getName()), (Object)"The converter should be initialized using a Item annotation.");
        this.parameterName = ((VariableValue)CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)itemAnnotation, (String)"item")).getValue().getVar();
        StringValue labelParam = (StringValue)CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)itemAnnotation, (String)"label");
        this.labelParameterName = labelParam == null ? "" : labelParam.getValue();
        StringValue hierarchyParam = (StringValue)CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)itemAnnotation, (String)"hierarchy");
        Item.HierarchyPolicy hierarchyPolicy = this.policy = hierarchyParam == null ? Item.HierarchyPolicy.ALWAYS : Item.HierarchyPolicy.valueOf(hierarchyParam.getValue().toUpperCase());
        if (formatAnnotation != null) {
            this.format = FormatParser.parseFormatAnnotation(formatAnnotation);
        }
    }

    public Object getToType() {
        return Item.class;
    }

    public Object getFromType() {
        return IPatternMatch.class;
    }

    public Object convert(Object fromObject) {
        IPatternMatch match = (IPatternMatch)fromObject;
        Object param = match.get(this.parameterName);
        Item item = new Item(match, param, this.labelParameterName, this.policy);
        item.setSpecification(this.format);
        return item;
    }
}

