/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchList;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchSet;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryFilterSemantics;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.viewers.runtime.model.ViewerFilterDefinition;

public class ViewerDataFilter {
    public static ViewerDataFilter UNFILTERED = new ViewerDataFilter();
    private Map<Pattern, ViewerFilterDefinition> filterDefinitions;

    public ViewerDataFilter() {
        this.filterDefinitions = Maps.newHashMap();
    }

    private ViewerDataFilter(Map<Pattern, ViewerFilterDefinition> filters) {
        this.filterDefinitions = Maps.newHashMap(filters);
    }

    public static ViewerDataFilter cloneFilter(ViewerDataFilter other) {
        return new ViewerDataFilter(other.filterDefinitions);
    }

    public void addSingleFilter(Pattern pattern, IPatternMatch match) {
        Preconditions.checkArgument((!this.filterDefinitions.containsKey(pattern) ? 1 : 0) != 0, (Object)("Filter already defined for pattern " + pattern.getName()));
        this.filterDefinitions.put(pattern, new ViewerFilterDefinition(pattern, IncQueryFilterSemantics.SINGLE, match, null));
    }

    public void addMultiFilter(Pattern pattern, Collection<IPatternMatch> matches, IncQueryFilterSemantics semantics) {
        Preconditions.checkArgument((!this.filterDefinitions.containsKey(pattern) ? 1 : 0) != 0, (Object)("Filter already defined for pattern " + pattern.getName()));
        this.filterDefinitions.put(pattern, new ViewerFilterDefinition(pattern, semantics, null, matches));
    }

    public void removeFilter(Pattern pattern) {
        Preconditions.checkArgument((boolean)this.filterDefinitions.containsKey(pattern), (Object)("Filter undefined for pattern " + pattern.getName()));
        this.filterDefinitions.remove(pattern);
    }

    public boolean isFiltered(Pattern pattern) {
        return this.filterDefinitions.containsKey(pattern);
    }

    public ViewerFilterDefinition getFilter(Pattern pattern) {
        return this.filterDefinitions.get(pattern);
    }

    public ObservablePatternMatchSet<IPatternMatch> getObservableSet(Pattern pattern, RuleEngine engine) {
        IQuerySpecification querySpecification = QuerySpecificationRegistry.getOrCreateQuerySpecification((Pattern)pattern);
        if (this.isFiltered(pattern)) {
            ViewerFilterDefinition def = this.getFilter(pattern);
            switch (def.semantics) {
                case SINGLE: {
                    return new ObservablePatternMatchSet(querySpecification, engine, def.singleFilterMatch);
                }
            }
            return new ObservablePatternMatchSet(querySpecification, engine, def.filterMatches, def.semantics);
        }
        return new ObservablePatternMatchSet(querySpecification, engine);
    }

    public ObservablePatternMatchList<IPatternMatch> getObservableList(Pattern pattern, RuleEngine engine) {
        IQuerySpecification querySpecification = QuerySpecificationRegistry.getOrCreateQuerySpecification((Pattern)pattern);
        if (this.isFiltered(pattern)) {
            ViewerFilterDefinition def = this.getFilter(pattern);
            switch (def.semantics) {
                case SINGLE: {
                    return new ObservablePatternMatchList(querySpecification, engine, def.singleFilterMatch);
                }
            }
            return new ObservablePatternMatchList(querySpecification, engine, def.filterMatches, def.semantics);
        }
        return new ObservablePatternMatchList(querySpecification, engine);
    }
}

