/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.MultiList;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.UnionSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchList;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchSet;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.api.resolver.ConflictResolver;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.Schedulers;
import org.eclipse.incquery.runtime.evm.specific.resolver.FixedPriorityConflictResolver;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataModel;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.model.ViewerStateList;
import org.eclipse.incquery.viewers.runtime.model.ViewerStateSet;
import org.eclipse.incquery.viewers.runtime.model.converters.ContainmentList;
import org.eclipse.incquery.viewers.runtime.model.converters.ContainmentSet;
import org.eclipse.incquery.viewers.runtime.model.converters.EdgeList;
import org.eclipse.incquery.viewers.runtime.model.converters.EdgeSet;
import org.eclipse.incquery.viewers.runtime.model.converters.ItemConverter;
import org.eclipse.incquery.viewers.runtime.util.ViewersConflictResolver;

public class IncQueryViewerDataModel
extends ViewerDataModel {
    private IncQueryEngine engine;
    private Logger logger;
    private Set<Pattern> patterns;
    RuleEngine ruleEngine;
    FixedPriorityConflictResolver resolver;
    protected static boolean setMode = false;

    public IncQueryViewerDataModel(Collection<Pattern> patterns, IncQueryEngine engine) {
        this.patterns = Sets.newHashSet(patterns);
        this.engine = engine;
        this.logger = engine.getLogger();
        this.ruleEngine = ExecutionSchemas.createIncQueryExecutionSchema((IncQueryEngine)engine, (Scheduler.ISchedulerFactory)Schedulers.getIQEngineSchedulerFactory((IncQueryEngine)engine));
        this.resolver = new ViewersConflictResolver();
        this.ruleEngine.setConflictResolver((ConflictResolver)this.resolver);
    }

    public IncQueryEngine getEngine() {
        return this.engine;
    }

    public Collection<Pattern> getPatterns(final String annotation) {
        return Collections2.filter(this.patterns, (Predicate)new Predicate<Pattern>(){

            public boolean apply(Pattern pattern) {
                return CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)pattern, (String)annotation) != null;
            }
        });
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void dispose() {
        if (this.ruleEngine != null) {
            this.ruleEngine.dispose();
        }
    }

    @Override
    public IObservableSet initializeObservableItemSet(ViewerDataFilter filter, final Multimap<Object, Item> itemMap) {
        IdentityHashMap nodeSetsObservable = new IdentityHashMap();
        for (Pattern nodePattern : this.getPatterns("Item")) {
            DataBindingContext ctx = new DataBindingContext();
            ObservablePatternMatchSet<IPatternMatch> nodeSet = filter.getObservableSet(nodePattern, this.ruleEngine);
            this.resolver.setPriority(nodeSet.getSpecification(), 1);
            Annotation formatAnnotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)nodePattern, (String)"Format");
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)nodePattern, (String)"Item")) {
                WritableSet resultSet = new WritableSet();
                nodeSetsObservable.put(resultSet, null);
                ctx.bindSet((IObservableSet)resultSet, nodeSet, null, new UpdateSetStrategy().setConverter((IConverter)new ItemConverter(annotation, formatAnnotation)));
            }
        }
        UnionSet Set2 = new UnionSet(nodeSetsObservable.keySet().toArray(new IObservableSet[0]));
        for (Object _item : Set2) {
            Item item = (Item)_item;
            itemMap.put(item.getParamObject(), (Object)item);
        }
        Set2.addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                Item item;
                for (Object element : event.diff.getAdditions()) {
                    if (!(element instanceof Item)) continue;
                    item = (Item)element;
                    itemMap.put(item.getParamObject(), (Object)item);
                }
                for (Object element : event.diff.getRemovals()) {
                    if (!(element instanceof Item)) continue;
                    item = (Item)element;
                    Object paramObject = item.getParamObject();
                    itemMap.remove(paramObject, element);
                }
            }
        });
        return Set2;
    }

    @Override
    public IObservableList initializeObservableItemList(ViewerDataFilter filter, final Multimap<Object, Item> itemMap) {
        ArrayList<WritableList> nodeListsObservable = new ArrayList<WritableList>();
        for (Pattern nodePattern : this.getPatterns("Item")) {
            DataBindingContext ctx = new DataBindingContext();
            ObservablePatternMatchList<IPatternMatch> nodeList = filter.getObservableList(nodePattern, this.ruleEngine);
            this.resolver.setPriority(nodeList.getSpecification(), 1);
            Annotation formatAnnotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)nodePattern, (String)"Format");
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)nodePattern, (String)"Item")) {
                WritableList resultList = new WritableList();
                nodeListsObservable.add(resultList);
                ctx.bindList((IObservableList)resultList, nodeList, null, new UpdateListStrategy().setConverter((IConverter)new ItemConverter(annotation, formatAnnotation)));
            }
        }
        MultiList list = new MultiList((IObservableList[])nodeListsObservable.toArray(new ObservableList[nodeListsObservable.size()]));
        for (Object _item : list) {
            Item item = (Item)_item;
            itemMap.put(item.getParamObject(), (Object)item);
        }
        list.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                event.diff.accept(new ListDiffVisitor(){

                    public void handleRemove(int index, Object element) {
                        if (element instanceof Item) {
                            Item item = (Item)element;
                            Object paramObject = item.getParamObject();
                            itemMap.remove(paramObject, element);
                        }
                    }

                    public void handleAdd(int index, Object element) {
                        if (element instanceof Item) {
                            Item item = (Item)element;
                            itemMap.put(item.getParamObject(), (Object)item);
                        }
                    }
                });
            }
        });
        return list;
    }

    @Override
    public IObservableSet initializeObservableEdgeSet(ViewerDataFilter filter, Multimap<Object, Item> itemMap) {
        HashSet<EdgeSet> edgeSetsObservable = new HashSet<EdgeSet>();
        for (Pattern edgePattern : this.getPatterns("Edge")) {
            ObservablePatternMatchSet<IPatternMatch> edgeSet = filter.getObservableSet(edgePattern, this.ruleEngine);
            this.resolver.setPriority(edgeSet.getSpecification(), 3);
            Annotation formatAnnotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)edgePattern, (String)"Format");
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)edgePattern, (String)"Edge")) {
                EdgeSet resultSet = new EdgeSet(annotation, formatAnnotation, itemMap, (IObservableSet)edgeSet);
                edgeSetsObservable.add(resultSet);
            }
        }
        UnionSet Set2 = new UnionSet(edgeSetsObservable.toArray(new IObservableSet[0]));
        return Set2;
    }

    public MultiList initializeObservableEdgeList(ViewerDataFilter filter, Multimap<Object, Item> itemMap) {
        ArrayList<EdgeList> edgeListsObservable = new ArrayList<EdgeList>();
        for (Pattern edgePattern : this.getPatterns("Edge")) {
            ObservablePatternMatchList<IPatternMatch> edgelist = filter.getObservableList(edgePattern, this.ruleEngine);
            this.resolver.setPriority(edgelist.getSpecification(), 3);
            Annotation formatAnnotation = CorePatternLanguageHelper.getFirstAnnotationByName((Pattern)edgePattern, (String)"Format");
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)edgePattern, (String)"Edge")) {
                EdgeList resultList = new EdgeList(annotation, formatAnnotation, itemMap, (IObservableList)edgelist);
                edgeListsObservable.add(resultList);
            }
        }
        MultiList list = new MultiList(edgeListsObservable.toArray(new IObservableList[edgeListsObservable.size()]));
        return list;
    }

    @Override
    public IObservableSet initializeObservableContainmentSet(ViewerDataFilter filter, Multimap<Object, Item> itemMap) {
        HashSet<ContainmentSet> containmentSetsObservable = new HashSet<ContainmentSet>();
        for (Pattern containmentPattern : this.getPatterns("ContainsItem")) {
            ObservablePatternMatchSet<IPatternMatch> containmentSet = filter.getObservableSet(containmentPattern, this.ruleEngine);
            this.resolver.setPriority(containmentSet.getSpecification(), 2);
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)containmentPattern, (String)"ContainsItem")) {
                ContainmentSet resultSet = new ContainmentSet(annotation, itemMap, (IObservableSet)containmentSet);
                containmentSetsObservable.add(resultSet);
            }
        }
        UnionSet Set2 = new UnionSet(containmentSetsObservable.toArray(new IObservableSet[0]));
        return Set2;
    }

    public MultiList initializeObservableContainmentList(ViewerDataFilter filter, Multimap<Object, Item> itemMap) {
        ArrayList<ContainmentList> containmentListsObservable = new ArrayList<ContainmentList>();
        for (Pattern containmentPattern : this.getPatterns("ContainsItem")) {
            ObservablePatternMatchList<IPatternMatch> containmentList = filter.getObservableList(containmentPattern, this.ruleEngine);
            this.resolver.setPriority(containmentList.getSpecification(), 2);
            for (Annotation annotation : CorePatternLanguageHelper.getAnnotationsByName((Pattern)containmentPattern, (String)"ContainsItem")) {
                ContainmentList resultList = new ContainmentList(annotation, itemMap, (IObservableList)containmentList);
                containmentListsObservable.add(resultList);
            }
        }
        MultiList list = new MultiList(containmentListsObservable.toArray(new IObservableList[containmentListsObservable.size()]));
        return list;
    }

    public static ViewerState newViewerState(IncQueryEngine engine, Collection<Pattern> patterns, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        IncQueryViewerDataModel m = new IncQueryViewerDataModel(patterns, engine);
        ViewerState r = IncQueryViewerDataModel.newViewerState(m, filter, features);
        r.hasExternalViewerDataModel = false;
        return r;
    }

    public static ViewerState newViewerState(IncQueryViewerDataModel model, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        ViewerState s = null;
        s = setMode ? new ViewerStateSet(model, filter, features) : new ViewerStateList(model, filter, features);
        s.hasExternalViewerDataModel = true;
        return s;
    }
}

