/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.tooling;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.helper.EMFPatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.incquery.tooling.core.generator.ExtensionGenerator;
import org.eclipse.incquery.tooling.core.generator.builder.IErrorFeedback;
import org.eclipse.incquery.tooling.core.generator.fragments.IGenerationFragment;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ValidationGenerator
implements IGenerationFragment {
    @Inject
    @Extension
    private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
    @Inject
    private IEiqGenmodelProvider eiqGenModelProvider;
    @Inject
    private IErrorFeedback feedback;
    private static String VALIDATIONEXTENSION_PREFIX = "validation.constraint.";
    private static String UI_VALIDATION_MENUS_PREFIX = "generated.incquery.validation.menu.";
    private static String VALIDATION_EXTENSION_POINT = "org.eclipse.incquery.validation.runtime.constraint";
    private static String ECLIPSE_MENUS_EXTENSION_POINT = "org.eclipse.ui.menus";
    private static String annotationLiteral = "Constraint";
    private static String VALIDATION_ERROR_CODE = "org.eclipse.incquery.validation.error";

    public void generateFiles(Pattern pattern, IFileSystemAccess fsa) {
        EList _annotations = pattern.getAnnotations();
        for (Annotation ann : _annotations) {
            String _name = ann.getName();
            boolean _equals = Objects.equal((Object)_name, (Object)annotationLiteral);
            if (!_equals) continue;
            String _constraintClassJavaFile = this.constraintClassJavaFile(pattern, ann);
            CharSequence _patternHandler = this.patternHandler(pattern, ann);
            fsa.generateFile(_constraintClassJavaFile, _patternHandler);
        }
    }

    public void cleanUp(Pattern pattern, IFileSystemAccess fsa) {
        EList _annotations = pattern.getAnnotations();
        for (Annotation ann : _annotations) {
            String _name = ann.getName();
            boolean _equals = Objects.equal((Object)_name, (Object)annotationLiteral);
            if (!_equals) continue;
            String _constraintClassJavaFile = this.constraintClassJavaFile(pattern, ann);
            fsa.deleteFile(_constraintClassJavaFile);
        }
    }

    public Iterable<Pair<String, String>> removeExtension(Pattern pattern) {
        Pair _of;
        String _menuContributionId;
        String _constraintContributionId = this.constraintContributionId(pattern);
        Pair p = Pair.of((Object)_constraintContributionId, (Object)VALIDATION_EXTENSION_POINT);
        ArrayList extensionList = CollectionLiterals.newArrayList((Object[])new Pair[]{p});
        EObject _eContainer = pattern.eContainer();
        PatternModel patternModel = (PatternModel)_eContainer;
        Iterable _packageImportsIterable = EMFPatternLanguageHelper.getPackageImportsIterable((PatternModel)patternModel);
        for (PackageImport imp : _packageImportsIterable) {
            boolean _not;
            boolean _notEquals;
            EPackage pack = imp.getEPackage();
            GenPackage genPackage = this.eiqGenModelProvider.findGenPackage((EObject)pattern, pack);
            boolean bl = _notEquals = !Objects.equal((Object)genPackage, null);
            if (!_notEquals) continue;
            String _qualifiedEditorClassName = genPackage.getQualifiedEditorClassName();
            String editorId = String.valueOf(_qualifiedEditorClassName) + "ID";
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)editorId);
            boolean bl2 = _not = !_isNullOrEmpty;
            if (!_not) continue;
            _menuContributionId = this.menuContributionId(editorId);
            _of = Pair.of((Object)_menuContributionId, (Object)ECLIPSE_MENUS_EXTENSION_POINT);
            extensionList.add(_of);
        }
        EList _annotations = pattern.getAnnotations();
        for (Annotation ann : _annotations) {
            String _name = ann.getName();
            boolean _equals = Objects.equal((Object)_name, (Object)annotationLiteral);
            if (!_equals) continue;
            ArrayList<ValueReference> editorIds = this.getAnnotationParameterValue(ann, "targetEditorId");
            for (ValueReference id : editorIds) {
                String editorId = ((StringValue)id).getValue();
                _menuContributionId = this.menuContributionId(editorId);
                _of = Pair.of((Object)_menuContributionId, (Object)ECLIPSE_MENUS_EXTENSION_POINT);
                extensionList.add(_of);
            }
        }
        return extensionList;
    }

    public Collection<Pair<String, String>> getRemovableExtensions() {
        Pair _of = Pair.of((Object)VALIDATIONEXTENSION_PREFIX, (Object)VALIDATION_EXTENSION_POINT);
        Pair _of_1 = Pair.of((Object)UI_VALIDATION_MENUS_PREFIX, (Object)ECLIPSE_MENUS_EXTENSION_POINT);
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new Pair[]{_of, _of_1});
        return _newArrayList;
    }

    public String[] getProjectDependencies() {
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.incquery.runtime", "org.eclipse.incquery.validation.runtime"});
        return (String[])Conversions.unwrapArray((Object)_newArrayList, String.class);
    }

    public String getProjectPostfix() {
        return "validation";
    }

    public Iterable<IPluginExtension> extensionContribution(final Pattern pattern, final ExtensionGenerator exGen) {
        String _constraintContributionId = this.constraintContributionId(pattern);
        Procedures.Procedure1<IPluginExtension> _function = new Procedures.Procedure1<IPluginExtension>(){

            public void apply(IPluginExtension it) {
                EList _annotations = pattern.getAnnotations();
                for (final Annotation ann : _annotations) {
                    String _name = ann.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)annotationLiteral);
                    if (!_equals) continue;
                    Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                        public void apply(IPluginElement it) {
                            String _constraintClassName = ValidationGenerator.this.constraintClassName(pattern, ann);
                            exGen.contribAttribute(it, "class", _constraintClassName);
                            String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
                            exGen.contribAttribute(it, "name", _fullyQualifiedName);
                            ArrayList<ValueReference> editorIds = ValidationGenerator.this.getAnnotationParameterValue(ann, "targetEditorId");
                            for (ValueReference id : editorIds) {
                                final String editorId = ((StringValue)id).getValue();
                                Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                                    public void apply(IPluginElement it) {
                                        exGen.contribAttribute(it, "editorId", editorId);
                                    }
                                };
                                exGen.contribElement((IPluginObject)it, "enabledForEditor", (Procedures.Procedure1)_function);
                            }
                            EObject _eContainer = pattern.eContainer();
                            PatternModel patternModel = (PatternModel)_eContainer;
                            Iterable _packageImportsIterable = EMFPatternLanguageHelper.getPackageImportsIterable((PatternModel)patternModel);
                            for (PackageImport imp : _packageImportsIterable) {
                                boolean _notEquals;
                                EPackage pack = imp.getEPackage();
                                GenPackage genPackage = ValidationGenerator.this.eiqGenModelProvider.findGenPackage((EObject)pattern, pack);
                                boolean bl = _notEquals = !Objects.equal((Object)genPackage, null);
                                if (!_notEquals) continue;
                                String _qualifiedEditorClassName = genPackage.getQualifiedEditorClassName();
                                final String editorId = String.valueOf(_qualifiedEditorClassName) + "ID";
                                Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                                    public void apply(IPluginElement it) {
                                        exGen.contribAttribute(it, "editorId", editorId);
                                    }
                                };
                                exGen.contribElement((IPluginObject)it, "enabledForEditor", (Procedures.Procedure1)_function);
                            }
                        }
                    };
                    exGen.contribElement((IPluginObject)it, "constraint", (Procedures.Procedure1)_function);
                }
            }
        };
        IPluginExtension _contribExtension = exGen.contribExtension(_constraintContributionId, VALIDATION_EXTENSION_POINT, (Procedures.Procedure1)_function);
        ArrayList extensionList = CollectionLiterals.newArrayList((Object[])new IPluginExtension[]{_contribExtension});
        return extensionList;
    }

    public String constraintClassName(Pattern pattern, Annotation annotation) {
        String _packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
        String _realPatternName = this._eMFPatternLanguageJvmModelInferrerUtil.realPatternName(pattern);
        String _firstUpper = StringExtensions.toFirstUpper((String)_realPatternName);
        EList _annotations = pattern.getAnnotations();
        int _indexOf = _annotations.indexOf((Object)annotation);
        String _format = String.format("%s.%s%s%s", _packageName, _firstUpper, annotationLiteral, _indexOf);
        return _format;
    }

    public String constraintClassPath(Pattern pattern, Annotation annotation) {
        String _packagePath = this._eMFPatternLanguageJvmModelInferrerUtil.getPackagePath(pattern);
        String _realPatternName = this._eMFPatternLanguageJvmModelInferrerUtil.realPatternName(pattern);
        String _firstUpper = StringExtensions.toFirstUpper((String)_realPatternName);
        EList _annotations = pattern.getAnnotations();
        int _indexOf = _annotations.indexOf((Object)annotation);
        String _format = String.format("%s/%s%s%s", _packagePath, _firstUpper, annotationLiteral, _indexOf);
        return _format;
    }

    public String constraintClassJavaFile(Pattern pattern, Annotation annotation) {
        String _constraintClassPath = this.constraintClassPath(pattern, annotation);
        String _plus = String.valueOf(_constraintClassPath) + ".java";
        return _plus;
    }

    public String constraintContributionId(Pattern pattern) {
        String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
        return String.valueOf(VALIDATIONEXTENSION_PREFIX) + _fullyQualifiedName;
    }

    public String menuContributionId(String editorId) {
        return String.format("%s%s", UI_VALIDATION_MENUS_PREFIX, editorId);
    }

    public String getElementOfConstraintAnnotation(Annotation annotation, String elementName) {
        String _value;
        ValueReference ap = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)elementName);
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && ap instanceof StringValue) {
            _matched = true;
            _switchResult = _value = ((StringValue)ap).getValue();
        }
        if (!_matched && ap instanceof VariableValue) {
            String _var;
            _matched = true;
            _value = ((VariableValue)ap).getValue();
            _switchResult = _var = _value.getVar();
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    public ArrayList<ValueReference> getAnnotationParameterValue(Annotation annotation, String elementName) {
        ArrayList values = CollectionLiterals.newArrayList((Object[])new ValueReference[0]);
        EList _parameters = annotation.getParameters();
        for (AnnotationParameter ap : _parameters) {
            String _name = ap.getName();
            boolean _matches = _name.matches(elementName);
            if (!_matches) continue;
            ValueReference _value = ap.getValue();
            values.add(_value);
        }
        return values;
    }

    public CharSequence patternHandler(Pattern pattern, Annotation annotation) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.ecore.EObject;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.incquery.validation.runtime.Constraint;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.incquery.validation.runtime.ValidationUtil;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.incquery.runtime.api.impl.BaseGeneratedQuerySpecification;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.incquery.runtime.exception.IncQueryException;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import ");
        String _packageName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
        String _plus = String.valueOf(_packageName_1) + ".";
        String _matchClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
        String _plus_1 = String.valueOf(_plus) + _matchClassName;
        _builder.append((Object)_plus_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import ");
        String _utilPackageName = this._eMFPatternLanguageJvmModelInferrerUtil.getUtilPackageName(pattern);
        String _plus_2 = String.valueOf(_utilPackageName) + ".";
        String _querySpecificationClassName = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
        String _plus_3 = String.valueOf(_plus_2) + _querySpecificationClassName;
        _builder.append((Object)_plus_3, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import ");
        String _packageName_2 = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
        String _plus_4 = String.valueOf(_packageName_2) + ".";
        String _matcherClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
        String _plus_5 = String.valueOf(_plus_4) + _matcherClassName;
        _builder.append((Object)_plus_5, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = pattern.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)annotationLiteral, "");
        EList _annotations = pattern.getAnnotations();
        int _indexOf = _annotations.indexOf((Object)annotation);
        _builder.append((Object)_indexOf, "");
        _builder.append((Object)" extends ");
        _builder.append((Object)annotationLiteral, "");
        _builder.append((Object)"<");
        String _matchClassName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
        _builder.append((Object)_matchClassName_1, "");
        _builder.append((Object)"> {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ");
        String _querySpecificationClassName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
        _builder.append((Object)_querySpecificationClassName_1, "\t");
        _builder.append((Object)" querySpecification;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = pattern.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "\t");
        _builder.append((Object)annotationLiteral, "\t");
        EList _annotations_1 = pattern.getAnnotations();
        int _indexOf_1 = _annotations_1.indexOf((Object)annotation);
        _builder.append((Object)_indexOf_1, "\t");
        _builder.append((Object)"() throws IncQueryException {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"querySpecification = ");
        String _querySpecificationClassName_2 = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
        _builder.append((Object)_querySpecificationClassName_2, "\t\t");
        _builder.append((Object)".instance();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getMessage() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return \"");
        String _elementOfConstraintAnnotation = this.getElementOfConstraintAnnotation(annotation, "message");
        String _convertToJavaString = Strings.convertToJavaString((String)_elementOfConstraintAnnotation);
        _builder.append((Object)_convertToJavaString, "\t\t");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public EObject getLocationObject(");
        String _matchClassName_2 = this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
        _builder.append((Object)_matchClassName_2, "\t");
        _builder.append((Object)" signature) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Object location = signature.get(\"");
        String _xblockexpression = null;
        String loc = this.getElementOfConstraintAnnotation(annotation, "location");
        Map _parameterPositionsByName = CorePatternLanguageHelper.getParameterPositionsByName((Pattern)pattern);
        boolean _containsKey = _parameterPositionsByName.containsKey(loc);
        boolean bl = _not = !_containsKey;
        if (_not) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"Location '");
            _builder_1.append((Object)loc, "");
            _builder_1.append((Object)"' is not a valid parameter name!");
            this.feedback.reportError((EObject)annotation, _builder_1.toString(), VALIDATION_ERROR_CODE, Severity.ERROR, "org.eclipse.incquery.tooling.core.generator.marker.fragment");
        }
        _xblockexpression = loc;
        _builder.append((Object)_xblockexpression, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if(location instanceof EObject){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return (EObject) location;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int getSeverity() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ValidationUtil.getSeverity(\"");
        String _elementOfConstraintAnnotation_1 = this.getElementOfConstraintAnnotation(annotation, "severity");
        _builder.append((Object)_elementOfConstraintAnnotation_1, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public BaseGeneratedQuerySpecification<");
        String _matcherClassName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
        _builder.append((Object)_matcherClassName_1, "\t");
        _builder.append((Object)"> getQuerySpecification() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return querySpecification;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public IPath[] getAdditionalBinIncludes() {
        Path _path = new Path("plugin.xml");
        return (IPath[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new IPath[]{_path}), IPath.class);
    }
}

