/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.eval;

import java.util.Collection;
import java.util.Map;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.eval.AbstractEvaluator;
import org.eclipse.incquery.runtime.rete.eval.AbstractEvaluatorNode;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.tuple.Clearable;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;

public abstract class OutputCachingEvaluatorNode
extends AbstractEvaluatorNode
implements Clearable {
    Map<Tuple, Tuple> outputCache = CollectionsFactory.getMap();

    public OutputCachingEvaluatorNode(ReteContainer reteContainer, ReteEngine<?> engine, AbstractEvaluator evaluator, int sourceTupleWidth) {
        super(reteContainer, engine, evaluator, sourceTupleWidth);
        reteContainer.registerClearable(this);
    }

    @Override
    public void clear() {
        this.outputCache.clear();
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        for (Tuple output : this.outputCache.values()) {
            collector.add(output);
        }
    }

    @Override
    public void update(Direction direction, Tuple updateElement) {
        switch (direction) {
            case INSERT: {
                Tuple insertedOutput = this.tupleFromResult(updateElement, this.evaluateTerm(updateElement));
                if (insertedOutput == null) break;
                this.outputCache.put(updateElement, insertedOutput);
                this.propagateUpdate(direction, insertedOutput);
                break;
            }
            case REVOKE: {
                Tuple revokedOutput = this.outputCache.remove(updateElement);
                if (revokedOutput == null) break;
                this.propagateUpdate(direction, revokedOutput);
            }
        }
    }
}

