/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.types;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ClassType;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EnumValue;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ReferenceType;
import org.eclipse.incquery.patternlanguage.patternLanguage.AggregatedValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.BoolValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.CountAggregator;
import org.eclipse.incquery.patternlanguage.patternLanguage.DoubleValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.FunctionEvaluationValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.IntValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ListValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.LiteralValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionTail;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.Type;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;

public class EMFPatternTypeUtil {
    public static EClassifier getClassifierForLiteralComputationEnumValueReference(ValueReference valueReference) {
        if (valueReference instanceof LiteralValueReference) {
            if (valueReference instanceof IntValue) {
                return EcorePackage.Literals.EINT;
            }
            if (valueReference instanceof StringValue) {
                return EcorePackage.Literals.ESTRING;
            }
            if (valueReference instanceof BoolValue) {
                return EcorePackage.Literals.EBOOLEAN;
            }
            if (valueReference instanceof DoubleValue) {
                return EcorePackage.Literals.EDOUBLE;
            }
            if (valueReference instanceof ListValue) {
                return null;
            }
        } else if (valueReference instanceof AggregatedValue) {
            AggregatedValue aggregatedValue = (AggregatedValue)valueReference;
            if (aggregatedValue.getAggregator() instanceof CountAggregator) {
                return EcorePackage.Literals.EINT;
            }
        } else {
            if (valueReference instanceof FunctionEvaluationValue) {
                FunctionEvaluationValue eval = (FunctionEvaluationValue)valueReference;
                eval.getExpression();
                return EcorePackage.Literals.EJAVA_OBJECT;
            }
            if (valueReference instanceof EnumValue) {
                EnumValue enumValue = (EnumValue)valueReference;
                return enumValue.getEnumeration();
            }
        }
        return null;
    }

    public static Type getTypeFromPathExpressionTail(PathExpressionTail pathExpressionTail) {
        if (pathExpressionTail == null) {
            return null;
        }
        if (pathExpressionTail.getTail() != null) {
            return EMFPatternTypeUtil.getTypeFromPathExpressionTail(pathExpressionTail.getTail());
        }
        return pathExpressionTail.getType();
    }

    public static Map<PathExpressionTail, EStructuralFeature> getAllFeaturesFromPathExpressionTail(PathExpressionTail pathExpressionTail) {
        HashMap types = Maps.newHashMap();
        EMFPatternTypeUtil.getAllFeaturesFromPathExpressionTail(pathExpressionTail, types);
        return types;
    }

    public static void getAllFeaturesFromPathExpressionTail(PathExpressionTail pathExpressionTail, Map<PathExpressionTail, EStructuralFeature> types) {
        if (pathExpressionTail != null) {
            ReferenceType referenceType;
            EStructuralFeature refname;
            Type type = pathExpressionTail.getType();
            if (type instanceof ReferenceType && (refname = (referenceType = (ReferenceType)type).getRefname()) != null) {
                types.put(pathExpressionTail, refname);
            }
            EMFPatternTypeUtil.getAllFeaturesFromPathExpressionTail(pathExpressionTail.getTail(), types);
        }
    }

    public static EClassifier getClassifierForType(Type type) {
        EClassifier result = null;
        if (type != null) {
            if (type instanceof ClassType) {
                result = ((ClassType)type).getClassname();
            } else if (type instanceof ReferenceType) {
                EStructuralFeature feature = ((ReferenceType)type).getRefname();
                if (feature instanceof EAttribute) {
                    EAttribute attribute = (EAttribute)feature;
                    result = attribute.getEAttributeType();
                } else if (feature instanceof EReference) {
                    EReference reference = (EReference)feature;
                    result = reference.getEReferenceType();
                }
            }
        }
        return result;
    }
}

