/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.patternlanguage.emf.EMFPatternLanguageScopeHelper;
import org.eclipse.incquery.patternlanguage.emf.ResolutionException;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ClassType;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EnumValue;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ReferenceType;
import org.eclipse.incquery.patternlanguage.emf.helper.EMFPatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.emf.scoping.IMetamodelProvider;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionHead;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionTail;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.Type;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.patternlanguage.patternLanguage.util.PatternLanguageSwitch;
import org.eclipse.incquery.patternlanguage.scoping.PatternLanguageDeclarativeScopeProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;

public class EMFPatternLanguageDeclarativeScopeProvider
extends PatternLanguageDeclarativeScopeProvider {
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IMetamodelProvider metamodelProvider;
    private final ParentScopeProvider expressionParentScopeProvider = new ParentScopeProvider();

    public IScope scope_EPackage(PackageImport ctx, EReference ref) {
        return this.metamodelProvider.getAllMetamodelObjects(this.delegateGetScope(ctx, ref), ctx);
    }

    public IScope scope_EClassifier(PatternBody ctx, EReference ref) {
        EObject root = EcoreUtil.getRootContainer((EObject)ctx);
        if (root instanceof PatternModel) {
            return this.createReferencedPackagesScope((PatternModel)root);
        }
        return IScope.NULLSCOPE;
    }

    public IScope scope_EClassifier(ClassType ctx, EReference ref) {
        EObject root = EcoreUtil.getRootContainer((EObject)ctx);
        if (root instanceof PatternModel) {
            return this.createReferencedPackagesScope((PatternModel)root);
        }
        return IScope.NULLSCOPE;
    }

    public IScope scope_EClassifier(Variable ctx, EReference ref) {
        EObject root = EcoreUtil.getRootContainer((EObject)ctx);
        if (root instanceof PatternModel) {
            return this.createReferencedPackagesScope((PatternModel)root);
        }
        return IScope.NULLSCOPE;
    }

    protected IScope createClassifierScope(Iterable<EClassifier> classifiers) {
        return Scopes.scopeFor(classifiers);
    }

    protected IScope createReferencedPackagesScope(PatternModel model) {
        ArrayList<EClassifier> allClassifiers = new ArrayList<EClassifier>();
        for (PackageImport decl : EMFPatternLanguageHelper.getPackageImportsIterable(model)) {
            if (decl.getEPackage() == null) continue;
            allClassifiers.addAll((Collection<EClassifier>)decl.getEPackage().getEClassifiers());
        }
        return this.createClassifierScope(allClassifiers);
    }

    public IScope scope_EStructuralFeature(PathExpressionHead ctx, EReference ref) {
        return (IScope)this.expressionParentScopeProvider.doSwitch((EObject)ctx);
    }

    public IScope scope_EStructuralFeature(PathExpressionTail ctx, EReference ref) {
        return (IScope)this.expressionParentScopeProvider.doSwitch(ctx.eContainer());
    }

    public IScope scope_EEnum(EnumValue ctx, EReference ref) {
        PatternModel model = (PatternModel)EcoreUtil.getRootContainer((EObject)ctx);
        ArrayList enums = Lists.newArrayList();
        for (PackageImport decl : EMFPatternLanguageHelper.getPackageImportsIterable(model)) {
            if (decl.getEPackage() == null) continue;
            Iterables.addAll((Collection)enums, (Iterable)Iterables.filter((Iterable)decl.getEPackage().getEClassifiers(), EEnum.class));
        }
        return Scopes.scopeFor((Iterable)enums);
    }

    public IScope scope_EEnumLiteral(EnumValue ctx, EReference ref) {
        EEnum type;
        try {
            type = ctx.getEnumeration();
            type = type != null ? type : EMFPatternLanguageScopeHelper.calculateEnumerationType((PathExpressionHead)ctx.eContainer());
        }
        catch (ResolutionException resolutionException) {
            return IScope.NULLSCOPE;
        }
        return this.calculateEnumLiteralScope(type);
    }

    private IScope calculateEnumLiteralScope(EEnum enumeration) {
        EList literals = enumeration.getELiterals();
        return Scopes.scopeFor((Iterable)literals, (Function)new Function<EEnumLiteral, QualifiedName>(){

            public QualifiedName apply(EEnumLiteral literal) {
                QualifiedName qualifiedName = EMFPatternLanguageDeclarativeScopeProvider.this.qualifiedNameConverter.toQualifiedName(literal.getLiteral());
                return qualifiedName;
            }
        }, (IScope)IScope.NULLSCOPE);
    }

    static class ParentScopeProvider
    extends PatternLanguageSwitch<IScope> {
        ParentScopeProvider() {
        }

        public IScope casePathExpressionHead(PathExpressionHead object) {
            return this.calculateReferences(object.getType());
        }

        public IScope casePathExpressionTail(PathExpressionTail object) {
            return this.calculateReferences(object.getType());
        }

        private IScope calculateReferences(Type type) {
            EClassifier classifier;
            EList targetReferences = Collections.emptyList();
            if (type instanceof ReferenceType) {
                EClassifier referredType = ((ReferenceType)type).getRefname().getEType();
                if (referredType instanceof EClass) {
                    targetReferences = ((EClass)referredType).getEAllStructuralFeatures();
                }
            } else if (type instanceof ClassType && (classifier = ((ClassType)type).getClassname()) instanceof EClass) {
                targetReferences = ((EClass)classifier).getEAllStructuralFeatures();
            }
            if (targetReferences.isEmpty()) {
                return IScope.NULLSCOPE;
            }
            return Scopes.scopeFor(targetReferences);
        }
    }
}

