/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.zest.sources;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.gef4.zest.core.viewers.IGraphEntityRelationshipContentProvider;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.zest.sources.AbstractZestContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ZestContentWithIsolatedNodesProvider
extends AbstractZestContentProvider
implements IGraphEntityRelationshipContentProvider {
    Table<Item, Item, Set<Edge>> edgeTable;

    public ZestContentWithIsolatedNodesProvider() {
        super(false);
    }

    public ZestContentWithIsolatedNodesProvider(boolean displayContainment) {
        super(displayContainment);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof ViewerState) {
            this.initializeEdgeTable(this.state);
        }
    }

    void initializeEdgeTable(ViewerState state) {
        this.edgeTable = HashBasedTable.create();
        this.addEdges(state.getEdges());
        if (this.displayContainment) {
            this.addEdges(state.getContainments());
        }
    }

    private void addEdges(IObservableCollection edges) {
        for (Object _edge : edges) {
            Edge edge = (Edge)_edge;
            this.addEdge(edge);
        }
    }

    private void addEdge(Edge edge) {
        Item source = edge.getSource();
        Item target = edge.getTarget();
        Set<Edge> edgeSet = null;
        if (this.edgeTable.contains((Object)source, (Object)target)) {
            edgeSet = (Set)this.edgeTable.get((Object)source, (Object)target);
        } else {
            edgeSet = Sets.newHashSet();
            this.edgeTable.put((Object)source, (Object)target, (Object)edgeSet);
        }
        edgeSet.add(edge);
    }

    private void removeEdge(Edge edge) {
        Item target;
        Item source = edge.getSource();
        if (this.edgeTable.contains((Object)source, (Object)(target = edge.getTarget()))) {
            Set edgeSet = (Set)this.edgeTable.get((Object)source, (Object)target);
            if (edgeSet.size() == 1) {
                this.edgeTable.remove((Object)source, (Object)target);
            } else {
                edgeSet.remove(edge);
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        IObservableCollection items = this.state.getItems();
        return items.toArray(new Object[items.size()]);
    }

    public Object[] getRelationships(Object source, Object dest) {
        if (this.edgeTable.contains(source, dest)) {
            Set edgeSet = (Set)this.edgeTable.get(source, dest);
            return edgeSet.toArray(new Edge[edgeSet.size()]);
        }
        return new Edge[0];
    }

    public void edgeAppeared(Edge edge) {
        this.addEdge(edge);
        this.viewer.addRelationship((Object)edge, (Object)edge.getSource(), (Object)edge.getTarget());
    }

    public void edgeDisappeared(Edge edge) {
        this.removeEdge(edge);
        this.viewer.removeRelationship((Object)edge);
    }
}

