package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.OperationReturnResultMatch;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.operationReturnResult pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class OperationReturnResultProcessor implements IMatchProcessor<OperationReturnResultMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pTemp1 the value of pattern parameter temp1 in the currently processed match
   * 
   */
  public abstract void process(final Operation pSelf, final Parameter pTemp1);
  
  @Override
  public void process(final OperationReturnResultMatch match) {
    process(match.getSelf(), match.getTemp1());
  }
}
