/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.patternregistry.handlers;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.patternregistry.IPatternInfo;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.ITextRegion;

public class ShowLocationHandler
extends AbstractHandler {
    @Inject
    private ILocationInFileProvider locationProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object element;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IPatternInfo) {
            IPatternInfo patternInfo = (IPatternInfo)element;
            this.setSelectionInXtextEditor(patternInfo);
        }
        return null;
    }

    protected void setSelectionInXtextEditor(IPatternInfo patternInfo) {
        IFile file = patternInfo.getRelatedFile();
        if (file != null) {
            IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart editorPart;
                IEditorReference editorReference = iEditorReferenceArray[n2];
                String editorId = editorReference.getId();
                if ("org.eclipse.incquery.patternlanguage.emf.EMFPatternLanguage".equals(editorId) && (editorPart = editorReference.getEditor(true)) instanceof XtextEditor) {
                    Pattern pattern;
                    ITextRegion location;
                    IFileEditorInput fileEditorInput;
                    XtextEditor xtextEditor = (XtextEditor)editorPart;
                    IEditorInput editorInput = xtextEditor.getEditorInput();
                    if (editorInput instanceof IFileEditorInput && (fileEditorInput = (IFileEditorInput)editorInput).getFile().equals((Object)file)) {
                        editorPart.getSite().getPage().bringToTop((IWorkbenchPart)editorPart);
                    }
                    if ((location = this.locationProvider.getSignificantTextRegion((EObject)(pattern = patternInfo.getPattern()))) != null) {
                        xtextEditor.reveal(location.getOffset(), location.getLength());
                        xtextEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(location.getOffset(), location.getLength()));
                    }
                }
                ++n2;
            }
        }
    }
}

