/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.extensibility;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.incquery.runtime.matchers.backend.IQueryBackend;
import org.eclipse.incquery.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.incquery.runtime.rete.matcher.ReteBackendFactory;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;

public class QueryBackendRegistry {
    private static final QueryBackendRegistry INSTANCE = new QueryBackendRegistry();
    private Map<Class<? extends IQueryBackend>, IQueryBackendFactory> queryBackendFactories = Maps.newHashMap();
    private Class<? extends IQueryBackend> defaultBackendClass = ReteEngine.class;
    private Class<? extends IQueryBackend> defaultCachingBackendClass = ReteEngine.class;

    private QueryBackendRegistry() {
        this.queryBackendFactories.put(ReteEngine.class, (IQueryBackendFactory)new ReteBackendFactory());
    }

    public static QueryBackendRegistry getInstance() {
        return INSTANCE;
    }

    public Class<? extends IQueryBackend> getDefaultBackendClass() {
        return this.defaultBackendClass;
    }

    public Class<? extends IQueryBackend> getDefaultCachingBackendClass() {
        return this.defaultCachingBackendClass;
    }

    public void registerQueryBackendFactory(Class<? extends IQueryBackend> backend, IQueryBackendFactory factory) {
        Preconditions.checkArgument((!this.queryBackendFactories.containsKey(backend) ? 1 : 0) != 0, (String)"Backend %s already registered", (Object[])new Object[]{backend.getName()});
        this.queryBackendFactories.put(backend, factory);
    }

    public void registerQueryBackendFactoryUnchecked(Class<? extends IQueryBackend> backend, IQueryBackendFactory factory) {
        if (!this.queryBackendFactories.containsKey(backend)) {
            this.queryBackendFactories.put(backend, factory);
        }
    }

    public IQueryBackendFactory getFactory(Class<? extends IQueryBackend> backend) {
        Preconditions.checkArgument((boolean)this.queryBackendFactories.containsKey(backend), (String)"Unknown backend %s", (Object[])new Object[]{backend.getName()});
        return this.queryBackendFactories.get(backend);
    }

    public Iterable<Map.Entry<Class<? extends IQueryBackend>, IQueryBackendFactory>> getAllKnownFactories() {
        return this.queryBackendFactories.entrySet();
    }
}

