/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.network;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.traceability.PatternTraceInfo;
import org.eclipse.incquery.runtime.rete.traceability.TraceInfo;

public abstract class BaseNode
implements Node {
    protected ReteContainer reteContainer;
    protected long nodeId;
    protected Object tag;
    protected Set<TraceInfo> traceInfos;

    public BaseNode(ReteContainer reteContainer) {
        this.reteContainer = reteContainer;
        this.nodeId = reteContainer.registerNode(this);
        this.traceInfos = new HashSet<TraceInfo>();
    }

    public String toString() {
        if (this.tag != null) {
            return String.valueOf(this.toStringCore()) + "->" + this.getTraceInfoPatternsEnumerated() + "{" + this.tag.toString() + "}";
        }
        return String.valueOf(this.toStringCore()) + "->" + this.getTraceInfoPatternsEnumerated();
    }

    protected String toStringCore() {
        return "[" + this.nodeId + "]" + this.getClass().getSimpleName();
    }

    @Override
    public ReteContainer getContainer() {
        return this.reteContainer;
    }

    @Override
    public long getNodeId() {
        return this.nodeId;
    }

    @Override
    public Object getTag() {
        return this.tag;
    }

    @Override
    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Override
    public Set<TraceInfo> getTraceInfos() {
        return Collections.unmodifiableSet(this.traceInfos);
    }

    @Override
    public void assignTraceInfo(TraceInfo traceInfo) {
        this.traceInfos.add(traceInfo);
        traceInfo.assignNode(this);
    }

    @Override
    public void acceptPropagatedTraceInfo(TraceInfo traceInfo) {
        this.assignTraceInfo(traceInfo);
    }

    protected String getTraceInfoPatternsEnumerated() {
        TreeSet<String> patternNames = new TreeSet<String>();
        for (TraceInfo trInfo : this.traceInfos) {
            if (!(trInfo instanceof PatternTraceInfo)) continue;
            String pName = ((PatternTraceInfo)trInfo).getPatternName();
            patternNames.add(pName);
        }
        return patternNames.toString();
    }
}

