/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.helpers.BuildHelper;
import org.eclipse.incquery.runtime.rete.construction.psystem.PSystem;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred.PatternCallBasedDeferred;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.tuple.TupleMask;

public class PatternMatchCounter<PatternDescription, StubHandle>
extends PatternCallBasedDeferred<PatternDescription, StubHandle> {
    private PVariable resultVariable;

    public PatternMatchCounter(PSystem<PatternDescription, StubHandle, ?> pSystem, Tuple actualParametersTuple, PatternDescription pattern, PVariable resultVariable) {
        super(pSystem, actualParametersTuple, pattern, Collections.singleton(resultVariable));
        this.resultVariable = resultVariable;
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return Collections.singleton(this.resultVariable);
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies() {
        HashMap<Set<PVariable>, Set<PVariable>> result = new HashMap<Set<PVariable>, Set<PVariable>>();
        result.put(this.getDeferringVariables(), this.getDeducedVariables());
        return result;
    }

    @Override
    protected void doDoReplaceVariables(PVariable obsolete, PVariable replacement) {
        if (this.resultVariable.equals(obsolete)) {
            this.resultVariable = replacement;
        }
    }

    @Override
    protected Set<PVariable> getCandidateQuantifiedVariables() {
        return this.actualParametersTuple.getDistinctElements();
    }

    @Override
    protected Stub<StubHandle> doCheckOn(Stub<StubHandle> stub) throws RetePatternBuildException {
        Stub sideStub = this.getSideStub();
        BuildHelper.JoinHelper<StubHandle> joinHelper = this.getJoinHelper(stub, sideStub);
        Integer resultPositionLeft = stub.getVariablesIndex().get(this.resultVariable);
        TupleMask primaryMask = joinHelper.getPrimaryMask();
        TupleMask secondaryMask = joinHelper.getSecondaryMask();
        Stub<StubHandle> counterBetaStub = this.buildable.buildCounterBetaNode(stub, sideStub, primaryMask, secondaryMask, joinHelper.getComplementerMask(), this.resultVariable);
        if (resultPositionLeft == null) {
            return counterBetaStub;
        }
        int resultPositionFinal = counterBetaStub.getVariablesTuple().getSize() - 1;
        Stub<StubHandle> equalityCheckerStub = this.buildable.buildEqualityChecker(counterBetaStub, new int[]{resultPositionFinal, resultPositionLeft});
        return this.buildable.buildTrimmer(equalityCheckerStub, TupleMask.omit(resultPositionFinal, 1 + resultPositionFinal), false);
    }

    @Override
    protected String toStringRest() {
        return String.valueOf(this.pSystem.getContext().printPattern(this.pattern)) + "@" + this.actualParametersTuple.toString() + "->" + this.resultVariable.toString();
    }
}

