/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.extend;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.operations.extend.ExtendOperation;

public class ExtendToEStructuralFeatureSource
extends ExtendOperation<EObject> {
    private int targetPosition;
    private EStructuralFeature feature;

    public ExtendToEStructuralFeatureSource(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        super(sourcePosition);
        this.targetPosition = targetPosition;
        this.feature = feature;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        Set values = context.getBaseIndex().findByFeatureValue(frame.getValue(this.targetPosition), this.feature);
        this.it = values.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("extend to source ").append(this.feature.getContainerClass().getSimpleName()).append('.').append(this.feature.getName());
        return builder.toString();
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.position, (Object)this.targetPosition, (Object[])new Integer[0]);
    }
}

