/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.plan;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.incquery.runtime.localsearch.operations.IMatcherBasedOperation;
import org.eclipse.incquery.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.incquery.runtime.localsearch.plan.SearchPlan;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;

public class SearchPlanExecutor {
    private int currentOperation;
    SearchPlan plan;
    private List<ISearchOperation> operations;
    private ISearchContext context;
    private Set<ILocalSearchAdapter> adapters = Sets.newHashSet();
    private BiMap<Integer, PVariable> variableMapping;

    public BiMap<Integer, PVariable> getVariableMapping() {
        return this.variableMapping;
    }

    public int getCurrentOperation() {
        return this.currentOperation;
    }

    public SearchPlan getSearchPlan() {
        return this.plan;
    }

    public void addAdapters(List<ILocalSearchAdapter> adapter) {
        this.adapters.addAll(adapter);
    }

    public void removeAdapters(List<ILocalSearchAdapter> adapter) {
        this.adapters.removeAll(adapter);
    }

    public SearchPlanExecutor(SearchPlan plan, ISearchContext context, Map<PVariable, Integer> variableMapping) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Context cannot be null");
        this.plan = plan;
        this.context = context;
        HashBiMap tmpMapping = HashBiMap.create();
        tmpMapping.putAll(variableMapping);
        this.variableMapping = tmpMapping.inverse();
        this.operations = plan.getOperations();
        this.currentOperation = -1;
    }

    private void init(MatchingFrame frame) throws LocalSearchException {
        if (this.currentOperation == -1) {
            ++this.currentOperation;
            ISearchOperation operation = this.operations.get(this.currentOperation);
            for (ILocalSearchAdapter adapter : this.adapters) {
                adapter.executorInitializing(this, frame);
            }
            this.addAdaptersWhenNeeded(operation, frame);
            operation.onInitialize(frame, this.context);
        } else if (this.currentOperation == this.operations.size()) {
            --this.currentOperation;
        } else {
            throw new LocalSearchException("Error while executing search plan");
        }
    }

    public double cost() {
        return 0.0;
    }

    public boolean execute(MatchingFrame frame) throws LocalSearchException {
        boolean matchFound;
        int upperBound = this.operations.size() - 1;
        this.init(frame);
        this.operationSelected(frame);
        while (this.currentOperation >= 0 && this.currentOperation <= upperBound) {
            ISearchOperation operation;
            if (this.operations.get(this.currentOperation).execute(frame, this.context)) {
                this.operationExecuted(frame);
                ++this.currentOperation;
                this.operationSelected(frame);
                if (this.currentOperation > upperBound) continue;
                operation = this.operations.get(this.currentOperation);
                this.addAdaptersWhenNeeded(operation, frame);
                operation.onInitialize(frame, this.context);
                continue;
            }
            this.operationExecuted(frame);
            operation = this.operations.get(this.currentOperation);
            operation.onBacktrack(frame, this.context);
            this.removeAdaptersWhenNeeded(operation);
            --this.currentOperation;
            this.operationSelected(frame);
        }
        boolean bl = matchFound = this.currentOperation > upperBound;
        if (matchFound) {
            for (ILocalSearchAdapter adapter : this.adapters) {
                adapter.matchFound(this, frame);
            }
        }
        return matchFound;
    }

    public void resetPlan() {
        this.currentOperation = -1;
    }

    public void printDebugInformation() {
        int i = 0;
        while (i < this.operations.size()) {
            Logger.getRootLogger().debug((Object)("[" + i + "]\t" + this.operations.get(i).toString()));
            ++i;
        }
    }

    private void addAdaptersWhenNeeded(ISearchOperation currentSearchOperation, MatchingFrame frame) {
        LocalSearchMatcher calledMatcher = null;
        if (currentSearchOperation instanceof IMatcherBasedOperation) {
            calledMatcher = ((IMatcherBasedOperation)((Object)currentSearchOperation)).getAndPrepareCalledMatcher(frame, this.context);
        }
        if (calledMatcher != null) {
            for (ILocalSearchAdapter adapter : this.adapters) {
                calledMatcher.addAdapter(adapter);
            }
        }
    }

    private void removeAdaptersWhenNeeded(ISearchOperation currentSearchOperation) {
        LocalSearchMatcher calledMatcher = null;
        if (currentSearchOperation instanceof IMatcherBasedOperation) {
            calledMatcher = ((IMatcherBasedOperation)((Object)currentSearchOperation)).getCalledMatcher();
        }
        if (calledMatcher != null) {
            for (ILocalSearchAdapter adapter : this.adapters) {
                calledMatcher.removeAdapter(adapter);
            }
        }
    }

    private void operationExecuted(MatchingFrame frame) {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.operationExecuted(this, frame);
        }
    }

    private void operationSelected(MatchingFrame frame) {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.operationSelected(this, frame);
        }
    }

    public ISearchContext getContext() {
        return this.context;
    }
}

