/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.resolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.specific.resolver.FixedPriorityConflictSet;
import org.eclipse.incquery.runtime.evm.specific.resolver.ReconfigurableConflictResolver;

public class FixedPriorityConflictResolver
extends ReconfigurableConflictResolver {
    protected Map<RuleSpecification<?>, Integer> priorities = Maps.newHashMap();

    public void setPriority(RuleSpecification<?> specification, int priority) {
        Preconditions.checkArgument((specification != null ? 1 : 0) != 0, (Object)"Specification cannot be null!");
        Integer oldPriority = this.priorities.get(specification);
        if (oldPriority != null && oldPriority == priority) {
            return;
        }
        this.priorities.put(specification, priority);
        Set sets = this.getConflictSets();
        for (WeakReference weakReference : sets) {
            FixedPriorityConflictSet conflictSet = (FixedPriorityConflictSet)weakReference.get();
            if (conflictSet == null) continue;
            conflictSet.setPriority(specification, priority);
        }
    }

    protected FixedPriorityConflictSet createReconfigurableConflictSet() {
        return new FixedPriorityConflictSet(this, this.priorities);
    }
}

