package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.PackageNestedPackageMatch;
import org.eclipse.incquery.uml.derivedfeatures.PackageNestedPackageMatcher;

/**
 * A pattern-specific query specification that can instantiate PackageNestedPackageMatcher in a type-safe way.
 * 
 * @see PackageNestedPackageMatcher
 * @see PackageNestedPackageMatch
 * 
 */
@SuppressWarnings("all")
public final class PackageNestedPackageQuerySpecification extends BaseGeneratedEMFQuerySpecification<PackageNestedPackageMatcher> {
  private PackageNestedPackageQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static PackageNestedPackageQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected PackageNestedPackageMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return PackageNestedPackageMatcher.on(engine);
  }
  
  @Override
  public PackageNestedPackageMatch newEmptyMatch() {
    return PackageNestedPackageMatch.newEmptyMatch();
  }
  
  @Override
  public PackageNestedPackageMatch newMatch(final Object... parameters) {
    return PackageNestedPackageMatch.newMatch((org.eclipse.uml2.uml.Package) parameters[0], (org.eclipse.uml2.uml.Package) parameters[1]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link PackageNestedPackageQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link PackageNestedPackageQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static PackageNestedPackageQuerySpecification INSTANCE = new PackageNestedPackageQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static PackageNestedPackageQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.packageNestedPackage";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","temp2");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.Package"),new PParameter("temp2", "org.eclipse.uml2.uml.Package"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_self = body.getOrCreateVariableByName("self");
      		PVariable var_temp2 = body.getOrCreateVariableByName("temp2");
      		PVariable var_package_0 = body.getOrCreateVariableByName("package_0");
      		PVariable var_temp1 = body.getOrCreateVariableByName("temp1");
      		PVariable var_packageableElement = body.getOrCreateVariableByName("packageableElement");
      		new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
      		new TypeConstraint(body, new FlatTuple(var_temp2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_self, "self"),
      		   new ExportedParameter(body, var_temp2, "temp2")
      		));
      		//     Package(package_0)
      		new TypeConstraint(body, new FlatTuple(var_package_0), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
      		//     temp1 == package_0
      		new Equality(body, var_temp1, var_package_0);
      		//     Package.packagedElement(self, packageableElement)
      		new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_self, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package", "packagedElement")));
      		new Equality(body, var__virtual_0_, var_packageableElement);
      		//     temp1 == packageableElement
      		new Equality(body, var_temp1, var_packageableElement);
      		//     temp2 == temp1
      		new Equality(body, var_temp2, var_temp1);
      		bodies.add(body);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("Surrogate");
      		annotation.addAttribute("feature", "nestedPackage");
      		addAnnotation(annotation);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
