/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.builder;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.helper.EMFPatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.emf.ui.builder.CleanSupport;
import org.eclipse.incquery.patternlanguage.emf.ui.builder.EclipseResourceSupport;
import org.eclipse.incquery.patternlanguage.emf.ui.builder.EnsurePluginSupport;
import org.eclipse.incquery.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternSetValidationDiagnostics;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternSetValidator;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternValidationStatus;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.tooling.core.generator.GenerateQuerySpecificationExtension;
import org.eclipse.incquery.tooling.core.generator.fragments.IGenerationFragment;
import org.eclipse.incquery.tooling.core.generator.fragments.IGenerationFragmentProvider;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.incquery.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.xtext.builder.BuilderParticipant;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

public class EMFPatternLanguageBuilderParticipant
extends BuilderParticipant {
    @Inject
    private Injector injector;
    @Inject
    private IGenerator generator;
    @Inject
    private IGenerationFragmentProvider fragmentProvider;
    @Inject
    private EMFPatternLanguageJvmModelInferrerUtil util;
    @Inject
    private EnsurePluginSupport ensureSupport;
    @Inject
    private CleanSupport cleanSupport;
    @Inject
    private EclipseResourceSupport eclipseResourceSupport;
    @Inject
    private GenerateQuerySpecificationExtension querySpecificationExtensionGenerator;
    @Inject
    private IEiqGenmodelProvider genmodelProvider;
    @Inject
    private Logger logger;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private PatternSetValidator validator;

    public void build(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        if (!this.isEnabled(context)) {
            return;
        }
        List relevantDeltas = this.getRelevantDeltas(context);
        if (relevantDeltas.isEmpty()) {
            return;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        IProject modelProject = context.getBuiltProject();
        if (context.getBuildType() == IXtextBuilderParticipant.BuildType.CLEAN || context.getBuildType() == IXtextBuilderParticipant.BuildType.RECOVERY) {
            this.cleanSupport.fullClean(context, (IProgressMonitor)progress.newChild(1));
            super.build(context, (IProgressMonitor)progress.newChild(1));
            if (context.getBuildType() == IXtextBuilderParticipant.BuildType.CLEAN) {
                return;
            }
        } else {
            this.ensureSupport.clean();
            this.cleanSupport.normalClean(context, relevantDeltas, (IProgressMonitor)progress.newChild(1));
        }
        super.build(context, (IProgressMonitor)progress.newChild(1));
        this.ensureSupport.ensure(modelProject, (IProgressMonitor)progress.newChild(1));
    }

    protected void handleChangedContents(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, EclipseResourceFileSystemAccess2 fileSystemAccess) throws CoreException {
        Resource deltaResource;
        URI uri = delta.getUri();
        IProject builtProject = context.getBuiltProject();
        if (uri.isPlatformResource() && builtProject.getName().equals(uri.segment(1)) && this.shouldGenerate(deltaResource = context.getResourceSet().getResource(delta.getUri(), true), context)) {
            try {
                this.registerCurrentSourceFolder(context, delta, fileSystemAccess);
                this.generator.doGenerate(deltaResource, (IFileSystemAccess)fileSystemAccess);
                this.doPostGenerate(deltaResource, context);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof CoreException) {
                    throw (CoreException)e.getCause();
                }
                throw e;
            }
        }
    }

    private void doPostGenerate(Resource deltaResource, IXtextBuilderParticipant.IBuildContext context) throws CoreException {
        PatternSetValidationDiagnostics validate = this.validator.validate(deltaResource);
        if (validate.getStatus() == PatternValidationStatus.ERROR) {
            return;
        }
        IProject project = context.getBuiltProject();
        this.calculateEMFModelProjects(deltaResource, project);
        TreeIterator it = deltaResource.getAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (obj instanceof Pattern) {
                boolean isPublic;
                Pattern pattern = (Pattern)obj;
                boolean bl = isPublic = !CorePatternLanguageHelper.isPrivate((Pattern)pattern);
                if (!isPublic) continue;
                this.executeGeneratorFragments(context.getBuiltProject(), pattern);
                this.ensureSupport.exportPackage(project, this.util.getPackageName(pattern));
                this.ensureSupport.exportPackage(project, this.util.getUtilPackageName(pattern));
                continue;
            }
            if (!(obj instanceof PatternModel)) continue;
            PatternModel model = (PatternModel)obj;
            List querySpecificationExtensionContribution = this.querySpecificationExtensionGenerator.extensionContribution(model);
            this.ensureSupport.appendAllExtension(project, querySpecificationExtensionContribution);
        }
    }

    private void calculateEMFModelProjects(Resource deltaResource, IProject project) {
        TreeIterator it = deltaResource.getAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof PatternModel)) continue;
            PatternModel patternModel = (PatternModel)obj;
            for (PackageImport packageImport : EMFPatternLanguageHelper.getPackageImportsIterable((PatternModel)patternModel)) {
                String modelPluginID;
                GenPackage genPackage = this.genmodelProvider.findGenPackage((EObject)packageImport, packageImport.getEPackage());
                if (genPackage == null || (modelPluginID = genPackage.getGenModel().getModelPluginID()) == null || modelPluginID.isEmpty()) continue;
                this.ensureSupport.addModelBundleId(project, modelPluginID);
            }
            it.prune();
        }
    }

    private void executeGeneratorFragments(IProject modelProject, Pattern pattern) throws CoreException {
        for (IGenerationFragment fragment : this.fragmentProvider.getFragmentsForPattern(pattern)) {
            try {
                this.injector.injectMembers((Object)fragment);
                this.executeGeneratorFragment(fragment, modelProject, pattern);
            }
            catch (Exception e) {
                String msg = String.format("Exception when executing generation for '%s' in fragment '%s'", CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern), fragment.getClass().getCanonicalName());
                this.logger.error((Object)msg, (Throwable)e);
            }
        }
    }

    private void executeGeneratorFragment(IGenerationFragment fragment, IProject modelProject, Pattern pattern) throws CoreException {
        IProject targetProject = this.createOrGetTargetProject(modelProject, fragment);
        EclipseResourceFileSystemAccess2 fsa = this.eclipseResourceSupport.createProjectFileSystemAccess(targetProject);
        fragment.generateFiles(pattern, (IFileSystemAccess)fsa);
        Iterable extensionContribution = fragment.extensionContribution(pattern);
        this.ensureSupport.appendAllExtension(targetProject, extensionContribution);
    }

    private IProject createOrGetTargetProject(IProject modelProject, IGenerationFragment fragment) throws CoreException {
        String postfix = fragment.getProjectPostfix();
        String modelProjectName = ProjectGenerationHelper.getBundleSymbolicName((IProject)modelProject);
        if (postfix == null || postfix.isEmpty()) {
            ProjectGenerationHelper.ensureBundleDependencies((IProject)modelProject, (List)Lists.newArrayList((Object[])fragment.getProjectDependencies()));
            return modelProject;
        }
        ArrayList dependencies = Lists.newArrayList();
        dependencies.add(modelProjectName);
        dependencies.addAll(this.ensureSupport.getModelBundleDependencies(modelProject));
        dependencies.addAll(Lists.newArrayList((Object[])fragment.getProjectDependencies()));
        IProject targetProject = this.fragmentProvider.getFragmentProject(modelProject, fragment);
        if (!targetProject.exists()) {
            ProjectGenerationHelper.initializePluginProject((IProject)targetProject, (List)dependencies, (IPath[])fragment.getAdditionalBinIncludes());
        } else {
            ProjectGenerationHelper.ensureBundleDependencies((IProject)targetProject, (List)dependencies);
        }
        return targetProject;
    }

    protected boolean shouldGenerate(Resource resource, IXtextBuilderParticipant.IBuildContext context) {
        try {
            Iterable storages = this.storage2UriMapper.getStorages(resource.getURI());
            for (Pair pair : storages) {
                if (!(pair.getFirst() instanceof IFile) || !((IProject)pair.getSecond()).equals((Object)context.getBuiltProject())) continue;
                IFile file = (IFile)pair.getFirst();
                return file.findMaxProblemSeverity("org.eclipse.xtext.ui.check", true, 2) != 2;
            }
            return false;
        }
        catch (CoreException exc) {
            throw new WrappedException((Exception)((Object)exc));
        }
    }
}

