/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hudson.war;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Executable {
    private final String[] jettyJars = new String[]{"libs/jetty.jar", "libs/jetty-web-app.jar", "libs/jetty-continuation.jar", "libs/jetty-util.jar", "libs/jetty-http.jar", "libs/jetty-io.jar", "libs/jetty-security.jar", "libs/jetty-servlet.jar", "libs/jetty-servlet-api.jar", "libs/jetty-xml.jar", "libs/hudson-jetty-war-executable.jar"};
    private List<String> arguments;

    public static void main(String[] args) throws Exception {
        String javaVersion = System.getProperty("java.version");
        StringTokenizer tokens = new StringTokenizer(javaVersion, ".-_");
        int majorVersion = Integer.parseInt(tokens.nextToken());
        int minorVersion = Integer.parseInt(tokens.nextToken());
        if (majorVersion < 2 && minorVersion < 6) {
            System.err.println("Hudson requires Java 6 or later.");
            System.err.println("Your java version is " + javaVersion);
            System.err.println("Java Home:  " + System.getProperty("java.home"));
            System.exit(0);
        }
        Executable executable = new Executable();
        executable.parseArguments(args);
        executable.launchJetty();
    }

    private void parseArguments(String[] args) throws IOException {
        this.arguments = Arrays.asList(args);
        for (String arg : this.arguments) {
            if (arg.startsWith("--version")) {
                System.out.println("Hudson Continuous Integration Server" + Executable.getHudsonVersion());
                System.exit(0);
                continue;
            }
            if (arg.startsWith("--usage")) {
                this.printUsage();
                break;
            }
            if (!arg.startsWith("--logfile=")) continue;
            String logFile = arg.substring("--logfile=".length());
            System.out.println("Logging information is send to file " + logFile);
            FileOutputStream fos = new FileOutputStream(new File(logFile));
            PrintStream ps = new PrintStream(fos);
            System.setOut(ps);
            System.setErr(ps);
            break;
        }
    }

    private void printUsage() throws IOException {
        String usageStr = "Hudson Continuous Integration Server " + Executable.getHudsonVersion() + "\n" + "Usage: java -jar hudson.war [--option=value] [--option=value] ... \n" + "\n" + "Options:\n" + "   --version                        Show Hudson version and quit\n" + "   --logfile=<filename>             Send the output log to this file\n" + "   --prefix=<prefix-string>         Add this prefix to all URLs (eg http://localhost:8080/prefix/resource). Default is none\n\n" + "   --httpPort=<value>               HTTP listening port. Default value is 8080\n\n" + "   --httpsPort=<value>              HTTPS listening port. Disabled by default\n" + "   --httpsKeyStore=<filepath>       Location of the SSL KeyStore file.\n" + "   --httpsKeyStorePassword=<value>  Password for the SSL KeyStore file\n\n" + "   --updateServer=<your server>     Specify your own update server (eg http://updates.mycompany.com/).\n" + "                                    For details see http://wiki.hudson-ci.org/Alternate+Update+Server\n\n" + "   --disableUpdateCenterSwitch      Disable the ability to specify alternate Update Center URL via Plugin Manager Advanced tab\n\n" + "   --skipInitSetup                  Skip the initial setup screen and start Hudson directly";
        System.out.println(usageStr);
        System.exit(0);
    }

    private void launchJetty() throws Exception {
        ProtectionDomain protectionDomain = Executable.class.getProtectionDomain();
        URL warUrl = protectionDomain.getCodeSource().getLocation();
        System.out.println(warUrl.getPath());
        List<URL> jarUrls = this.extractJettyJarsFromWar(warUrl.getPath());
        URLClassLoader urlClassLoader = new URLClassLoader(jarUrls.toArray(new URL[jarUrls.size()]));
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        Class<?> jettyUtil = urlClassLoader.loadClass("org.eclipse.hudson.jetty.JettyLauncher");
        Method mainMethod = jettyUtil.getMethod("start", String[].class, URL.class);
        mainMethod.invoke(null, this.arguments.toArray(new String[this.arguments.size()]), warUrl);
    }

    private static String getHudsonVersion() throws IOException {
        Enumeration<URL> manifests = Executable.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (manifests.hasMoreElements()) {
            URL manifestUrl = manifests.nextElement();
            Manifest manifest = new Manifest(manifestUrl.openStream());
            String hudsonVersion = manifest.getMainAttributes().getValue("Hudson-Version");
            if (hudsonVersion == null) continue;
            return hudsonVersion;
        }
        return "Unknown Version";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URL> extractJettyJarsFromWar(String warPath) throws IOException {
        JarFile jarFile = new JarFile(warPath);
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        InputStream inStream = null;
        try {
            for (String entryPath : this.jettyJars) {
                File tmpFile;
                try {
                    tmpFile = File.createTempFile(entryPath.replaceAll("/", "_"), "hudson");
                }
                catch (IOException e) {
                    String tmpdir = System.getProperty("java.io.tmpdir");
                    throw new IOException("Failed to extract " + entryPath + " to " + tmpdir, e);
                }
                JarEntry jarEntry = jarFile.getJarEntry(entryPath);
                inStream = jarFile.getInputStream(jarEntry);
                FileOutputStream outStream = new FileOutputStream(tmpFile);
                try {
                    int readLength;
                    byte[] buffer = new byte[8192];
                    while ((readLength = inStream.read(buffer)) > 0) {
                        ((OutputStream)outStream).write(buffer, 0, readLength);
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                finally {
                    ((OutputStream)outStream).close();
                }
                tmpFile.deleteOnExit();
                jarUrls.add(tmpFile.toURI().toURL());
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
        return jarUrls;
    }
}

