/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.util;

import io.quarkus.fs.util.ZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.function.Function;

public class ClassPathUtils {
    private static final String FILE = "file";
    private static final String JAR = "jar";

    public static String toResourceName(Path path) {
        if (path == null) {
            return null;
        }
        if (path.getFileSystem().getSeparator().equals("/")) {
            return path.toString();
        }
        return path.toString().replace(path.getFileSystem().getSeparator(), "/");
    }

    public static void consumeAsStreams(String resource, Consumer<InputStream> consumer) throws IOException {
        ClassPathUtils.consumeAsStreams(Thread.currentThread().getContextClassLoader(), resource, consumer);
    }

    public static void consumeAsStreams(ClassLoader cl, String resource, Consumer<InputStream> consumer) throws IOException {
        Enumeration<URL> resources = cl.getResources(resource);
        while (resources.hasMoreElements()) {
            ClassPathUtils.consumeStream(resources.nextElement(), consumer);
        }
    }

    public static void consumeAsPaths(String resource, Consumer<Path> consumer) throws IOException {
        ClassPathUtils.consumeAsPaths(Thread.currentThread().getContextClassLoader(), resource, consumer);
    }

    public static void consumeAsPaths(ClassLoader cl, String resource, Consumer<Path> consumer) throws IOException {
        Enumeration<URL> resources = cl.getResources(resource);
        while (resources.hasMoreElements()) {
            ClassPathUtils.consumeAsPath(resources.nextElement(), consumer);
        }
    }

    public static void consumeAsPath(URL url, Consumer<Path> consumer) {
        ClassPathUtils.processAsPath(url, p -> {
            consumer.accept((Path)p);
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <R> R processAsPath(URL url, Function<Path, R> function) {
        Path jar;
        if (!JAR.equals(url.getProtocol())) {
            if (!FILE.equals(url.getProtocol())) throw new IllegalArgumentException("Unexpected protocol " + url.getProtocol() + " for URL " + url);
            return function.apply(ClassPathUtils.toLocalPath(url));
        }
        String file = url.getFile();
        int exclam = file.lastIndexOf(33);
        try {
            jar = ClassPathUtils.toLocalPath(exclam >= 0 ? new URL(file.substring(0, exclam)) : url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create a URL for '" + file.substring(0, exclam) + "'", e);
        }
        try (FileSystem jarFs = ZipUtils.newFileSystem(jar);){
            Path localPath = exclam >= 0 ? jarFs.getPath(file.substring(exclam + 1), new String[0]) : jarFs.getPath("/", new String[0]);
            R r = function.apply(localPath);
            return r;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + jar, e);
        }
    }

    public static void consumeStream(URL url, Consumer<InputStream> consumer) throws IOException {
        ClassPathUtils.readStream(url, is -> {
            consumer.accept((InputStream)is);
            return null;
        });
    }

    public static <R> R readStream(URL url, Function<InputStream, R> function) throws IOException {
        if (JAR.equals(url.getProtocol())) {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            try (InputStream is = urlConnection.getInputStream();){
                R r = function.apply(is);
                return r;
            }
        }
        if (FILE.equals(url.getProtocol())) {
            try (InputStream is = Files.newInputStream(ClassPathUtils.toLocalPath(url), new OpenOption[0]);){
                R r = function.apply(is);
                return r;
            }
        }
        try (InputStream is = url.openStream();){
            R r = function.apply(is);
            return r;
        }
    }

    public static Path toLocalPath(URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to translate " + url + " to local path", e);
        }
    }
}

