/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.htdigest.HtdigestAuth;
import io.vertx.ext.auth.htdigest.HtdigestCredentials;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.DigestAuthHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DigestAuthHandlerImpl
extends HTTPAuthorizationHandler<HtdigestAuth>
implements DigestAuthHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPAuthorizationHandler.class);
    private static final String DEFAULT_NONCE_MAP_NAME = "htdigest.nonces";
    private static final Pattern PARSER = Pattern.compile("(\\w+)=[\"]?([^\"]*)[\"]?$");
    private static final Pattern SPLITTER = Pattern.compile(",(?=(?:[^\"]|\"[^\"]*\")*$)");
    private static final MessageDigest MD5;
    private final VertxContextPRNG random;
    private final LocalMap<String, Nonce> nonces;
    private final long nonceExpireTimeout;
    private long lastExpireRun;

    public DigestAuthHandlerImpl(Vertx vertx, HtdigestAuth authProvider, long nonceExpireTimeout) {
        super(authProvider, HTTPAuthorizationHandler.Type.DIGEST, authProvider.realm());
        this.random = VertxContextPRNG.current(vertx);
        this.nonces = vertx.sharedData().getLocalMap(DEFAULT_NONCE_MAP_NAME);
        this.nonceExpireTimeout = nonceExpireTimeout;
    }

    @Override
    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        long now = System.currentTimeMillis();
        if (now - this.lastExpireRun > this.nonceExpireTimeout / 2L) {
            HashSet toRemove = new HashSet();
            this.nonces.forEach((key, n) -> {
                if (n != null && ((Nonce)n).createdAt + this.nonceExpireTimeout < now) {
                    toRemove.add(key);
                }
            });
            for (String n2 : toRemove) {
                this.nonces.remove(n2);
            }
            this.lastExpireRun = now;
        }
        this.parseAuthorization(context, parseAuthorization -> {
            String opaque;
            if (parseAuthorization.failed()) {
                handler.handle(Future.failedFuture(parseAuthorization.cause()));
                return;
            }
            HtdigestCredentials authInfo = new HtdigestCredentials();
            try {
                String[] tokens = SPLITTER.split((CharSequence)parseAuthorization.result());
                int len = tokens.length;
                block28: for (int i = 0; i < len; ++i) {
                    Matcher m = PARSER.matcher(tokens[i]);
                    if (!m.find()) continue;
                    switch (m.group(1)) {
                        case "algorithm": {
                            authInfo.setAlgorithm(m.group(2));
                            continue block28;
                        }
                        case "cnonce": {
                            authInfo.setCnonce(m.group(2));
                            continue block28;
                        }
                        case "method": {
                            authInfo.setMethod(m.group(2));
                            continue block28;
                        }
                        case "nc": {
                            authInfo.setNc(m.group(2));
                            continue block28;
                        }
                        case "nonce": {
                            authInfo.setNonce(m.group(2));
                            continue block28;
                        }
                        case "opaque": {
                            authInfo.setOpaque(m.group(2));
                            continue block28;
                        }
                        case "qop": {
                            authInfo.setQop(m.group(2));
                            continue block28;
                        }
                        case "realm": {
                            authInfo.setRealm(m.group(2));
                            continue block28;
                        }
                        case "response": {
                            authInfo.setResponse(m.group(2));
                            continue block28;
                        }
                        case "uri": {
                            authInfo.setUri(m.group(2));
                            continue block28;
                        }
                        case "username": {
                            authInfo.setUsername(m.group(2));
                            continue block28;
                        }
                        default: {
                            LOG.info("Uknown parameter: " + m.group(1));
                        }
                    }
                }
                String nonce = authInfo.getNonce();
                if (!this.nonces.containsKey(nonce)) {
                    handler.handle(Future.failedFuture(UNAUTHORIZED));
                    return;
                }
                if (authInfo.getQop() != null) {
                    Nonce n;
                    int nc = Integer.parseInt(authInfo.getNc(), 16);
                    if (nc <= (n = this.nonces.get(nonce)).count) {
                        handler.handle(Future.failedFuture(UNAUTHORIZED));
                        return;
                    }
                    this.nonces.put(nonce, new Nonce(n.createdAt, nc));
                }
            }
            catch (RuntimeException e) {
                handler.handle(Future.failedFuture(e));
                return;
            }
            Session session = context.session();
            if (session != null && (opaque = (String)session.data().get("opaque")) != null && !opaque.equals(authInfo.getOpaque())) {
                handler.handle(Future.failedFuture(UNAUTHORIZED));
                return;
            }
            authInfo.setMethod(context.request().method().name());
            ((HtdigestAuth)this.authProvider).authenticate((Credentials)authInfo, authn -> {
                if (authn.failed()) {
                    handler.handle(Future.failedFuture(new HttpException(401, authn.cause())));
                } else {
                    handler.handle((AsyncResult<User>)authn);
                }
            });
        });
    }

    @Override
    public boolean setAuthenticateHeader(RoutingContext context) {
        byte[] bytes = new byte[32];
        this.random.nextBytes(bytes);
        String nonce = DigestAuthHandlerImpl.md5(bytes);
        this.nonces.put(nonce, new Nonce(0));
        String opaque = null;
        Session session = context.session();
        if (session != null) {
            opaque = (String)session.data().get("opaque");
        }
        if (opaque == null) {
            this.random.nextBytes(bytes);
            opaque = DigestAuthHandlerImpl.md5(bytes);
        }
        context.response().headers().add("WWW-Authenticate", "Digest realm=\"" + this.realm + "\", qop=\"auth\", nonce=\"" + nonce + "\", opaque=\"" + opaque + "\"");
        return true;
    }

    private static synchronized String md5(byte[] payload) {
        MD5.reset();
        return Codec.base16Encode(MD5.digest(payload));
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Nonce
    implements Shareable {
        private final long createdAt;
        private final int count;

        Nonce(int count) {
            this(System.currentTimeMillis(), count);
        }

        Nonce(long createdAt, int count) {
            this.createdAt = createdAt;
            this.count = count;
        }
    }
}

