/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.fs.util.base;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

public abstract class DelegatingPath
implements Path {
    protected final Path delegate;
    private volatile URI uri;

    protected DelegatingPath(Path delegate) {
        this.delegate = delegate;
    }

    public static Path unwrap(Path path) {
        if (path instanceof DelegatingPath) {
            return ((DelegatingPath)path).getDelegate();
        }
        return path;
    }

    public Path getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean startsWith(String other) {
        return this.delegate.startsWith(other);
    }

    @Override
    public boolean endsWith(String other) {
        return this.delegate.endsWith(other);
    }

    @Override
    public Path resolve(String other) {
        return this.delegate.resolve(other);
    }

    @Override
    public Path resolveSibling(Path other) {
        return this.delegate.resolveSibling(other);
    }

    @Override
    public Path resolveSibling(String other) {
        return this.delegate.resolveSibling(other);
    }

    @Override
    public File toFile() {
        return this.delegate.toFile();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.delegate.register(watcher, events);
    }

    @Override
    public Iterator<Path> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.delegate.getFileSystem();
    }

    @Override
    public boolean isAbsolute() {
        return this.delegate.isAbsolute();
    }

    @Override
    public Path getRoot() {
        return this.delegate.getRoot();
    }

    @Override
    public Path getFileName() {
        return this.delegate.getFileName();
    }

    @Override
    public Path getParent() {
        return this.delegate.getParent();
    }

    @Override
    public int getNameCount() {
        return this.delegate.getNameCount();
    }

    @Override
    public Path getName(int index) {
        return this.delegate.getName(index);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        return this.delegate.subpath(beginIndex, endIndex);
    }

    @Override
    public boolean startsWith(Path other) {
        return this.delegate.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        return this.delegate.endsWith(other);
    }

    @Override
    public Path normalize() {
        return this.delegate.normalize();
    }

    @Override
    public Path resolve(Path other) {
        return this.delegate.resolve(other);
    }

    @Override
    public Path relativize(Path other) {
        return this.delegate.relativize(other);
    }

    @Override
    public URI toUri() {
        if (this.uri == null) {
            this.uri = this.delegate.toUri();
        }
        return this.uri;
    }

    @Override
    public Path toAbsolutePath() {
        return this.delegate.toAbsolutePath();
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.delegate.toRealPath(options);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.delegate.register(watcher, events, modifiers);
    }

    @Override
    public int compareTo(Path other) {
        return this.delegate.compareTo(other);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void forEach(Consumer<? super Path> action) {
        this.delegate.forEach(action);
    }

    @Override
    public Spliterator<Path> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatingPath that = (DelegatingPath)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

