/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.List;
import java.util.Map;
import java.util.Set;

@VertxGen
public interface AsyncMap<K, V> {
    default public void get(K k, Handler<AsyncResult<@Nullable V>> resultHandler) {
        this.get(k).onComplete(resultHandler);
    }

    public Future<@Nullable V> get(K var1);

    default public void put(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
        this.put(k, v).onComplete(completionHandler);
    }

    public Future<Void> put(K var1, V var2);

    default public void put(K k, V v, long ttl, Handler<AsyncResult<Void>> completionHandler) {
        this.put(k, v, ttl).onComplete(completionHandler);
    }

    public Future<Void> put(K var1, V var2, long var3);

    default public void putIfAbsent(K k, V v, Handler<AsyncResult<@Nullable V>> completionHandler) {
        this.putIfAbsent(k, v).onComplete(completionHandler);
    }

    public Future<@Nullable V> putIfAbsent(K var1, V var2);

    default public void putIfAbsent(K k, V v, long ttl, Handler<AsyncResult<@Nullable V>> completionHandler) {
        this.putIfAbsent(k, v, ttl).onComplete(completionHandler);
    }

    public Future<@Nullable V> putIfAbsent(K var1, V var2, long var3);

    default public void remove(K k, Handler<AsyncResult<@Nullable V>> resultHandler) {
        this.remove(k).onComplete(resultHandler);
    }

    public Future<@Nullable V> remove(K var1);

    default public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) {
        this.removeIfPresent(k, v).onComplete(resultHandler);
    }

    public Future<Boolean> removeIfPresent(K var1, V var2);

    default public void replace(K k, V v, Handler<AsyncResult<@Nullable V>> resultHandler) {
        this.replace(k, v).onComplete(resultHandler);
    }

    public Future<@Nullable V> replace(K var1, V var2);

    default public void replace(K k, V v, long ttl, Handler<AsyncResult<@Nullable V>> resultHandler) {
        this.replace(k, v, ttl).onComplete(resultHandler);
    }

    default public Future<@Nullable V> replace(K k, V v, long ttl) {
        return Future.failedFuture(new UnsupportedOperationException());
    }

    default public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) {
        this.replaceIfPresent(k, oldValue, newValue).onComplete(resultHandler);
    }

    public Future<Boolean> replaceIfPresent(K var1, V var2, V var3);

    default public void replaceIfPresent(K k, V oldValue, V newValue, long ttl, Handler<AsyncResult<Boolean>> resultHandler) {
        this.replaceIfPresent(k, oldValue, newValue, ttl).onComplete(resultHandler);
    }

    default public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue, long ttl) {
        return Future.failedFuture(new UnsupportedOperationException());
    }

    default public void clear(Handler<AsyncResult<Void>> resultHandler) {
        this.clear().onComplete(resultHandler);
    }

    public Future<Void> clear();

    default public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.size().onComplete(resultHandler);
    }

    public Future<Integer> size();

    @GenIgnore
    default public void keys(Handler<AsyncResult<Set<K>>> resultHandler) {
        this.keys().onComplete(resultHandler);
    }

    @GenIgnore
    public Future<Set<K>> keys();

    @GenIgnore
    default public void values(Handler<AsyncResult<List<V>>> resultHandler) {
        this.values().onComplete(resultHandler);
    }

    @GenIgnore
    public Future<List<V>> values();

    @GenIgnore
    default public void entries(Handler<AsyncResult<Map<K, V>>> resultHandler) {
        this.entries().onComplete(resultHandler);
    }

    @GenIgnore
    public Future<Map<K, V>> entries();
}

