/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.util;

import java.util.concurrent.CompletionException;
import org.eclipse.hono.client.ServiceInvocationException;
import picocli.CommandLine;

public final class CommandUtils {
    public static final String DESCRIPTION_ENV_VARS = "This property supports references to OS environment variables like $${MY_VARIABLE}, with MY_VARIABLE being the name of the OS environment variable that contains the value to use.\n";

    private CommandUtils() {
    }

    public static void printError(Throwable t) {
        if (t instanceof ServiceInvocationException) {
            ServiceInvocationException cause = (ServiceInvocationException)t;
            System.err.printf("Error: %d %s%n", cause.getErrorCode(), ServiceInvocationException.getErrorMessageForExternalClient(cause));
        } else {
            System.err.println("Error: %s".formatted(t.getMessage()));
        }
    }

    public static int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult parseResult) {
        Exception cause = ex instanceof CompletionException ? (Exception)ex.getCause() : ex;
        CommandUtils.printError(cause);
        return 1;
    }
}

