/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.tests;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.git.JGitRepository;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.eclipse.hawk.integration.tests.mm.Tree.Tree;
import org.eclipse.hawk.integration.tests.mm.Tree.TreeFactory;
import org.eclipse.hawk.timeaware.tests.AbstractTimeAwareModelIndexingTest;
import org.eclipse.hawk.timeaware.tests.TimeAwareTestSuite;
import org.eclipse.jgit.api.Git;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GitNodeHistoryTest
extends AbstractTimeAwareModelIndexingTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return TimeAwareTestSuite.caseParams();
    }

    public GitNodeHistoryTest(File baseDir, IGraphDatabaseFactory dbFactory) {
        super(baseDir, dbFactory, (ModelIndexingTest.IModelSupportFactory)new EMFModelSupportFactory());
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Git.init().setDirectory(this.folder.getRoot()).call();
    }

    @Override
    protected void setUpMetamodels() throws Exception {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Tree.ecore")});
    }

    @Test
    public void defaultBranch() throws Throwable {
        File fTree = new File(this.folder.getRoot(), "root.xmi");
        Resource rTree = this.rsTree.createResource(URI.createFileURI((String)fTree.getAbsolutePath()));
        Tree tRoot = TreeFactory.eINSTANCE.createTree();
        tRoot.setLabel("root");
        rTree.getContents().add((Object)tRoot);
        rTree.save(null);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Git git = Git.open((File)this.folder.getRoot());){
            git.add().addFilepattern(fTree.getName()).call();
            git.commit().setMessage("first commit").call();
            Tree tChild = TreeFactory.eINSTANCE.createTree();
            tChild.setLabel("child");
            tRoot.getChildren().add((Object)tChild);
            rTree.save(null);
            git.commit().setAll(true).setMessage("second commit").call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        JGitRepository vcs = new JGitRepository();
        vcs.init(this.folder.getRoot().getAbsolutePath(), this.indexer);
        vcs.run();
        this.indexer.addVCSManager((IVcsManager)vcs, true);
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)3, (Object)this.timeAwareEOL("return Tree.versions.size;"));
            Assert.assertEquals((Object)2, (Object)this.timeAwareEOL("return Tree.latest.all.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Tree.latest.prev.all.size;"));
            Assert.assertEquals((Object)0, (Object)this.timeAwareEOL("return Tree.latest.prev.prev.all.size;"));
            return null;
        });
    }

    @Test
    public void nonDefaultBranch() throws Throwable {
        File fTree = new File(this.folder.getRoot(), "root.xmi");
        Resource rTree = this.rsTree.createResource(URI.createFileURI((String)fTree.getAbsolutePath()));
        Tree tRoot = TreeFactory.eINSTANCE.createTree();
        tRoot.setLabel("root");
        rTree.getContents().add((Object)tRoot);
        rTree.save(null);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Git git = Git.open((File)this.folder.getRoot());){
            git.add().addFilepattern(fTree.getName()).call();
            git.commit().setMessage("first commit").call();
            Tree tChild = TreeFactory.eINSTANCE.createTree();
            tChild.setLabel("child");
            tRoot.getChildren().add((Object)tChild);
            rTree.save(null);
            git.commit().setAll(true).setMessage("second commit").call();
            String defaultBranch = git.getRepository().getBranch();
            git.checkout().setName("newbranch").setCreateBranch(true).call();
            tChild.setLabel("changed");
            rTree.save(null);
            git.commit().setAll(true).setMessage("third commit in new branch").call();
            git.checkout().setName(defaultBranch).call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        JGitRepository vcs = new JGitRepository();
        vcs.init(String.valueOf(this.folder.getRoot().toURI().toString()) + "?branch=newbranch", this.indexer);
        vcs.run();
        this.indexer.addVCSManager((IVcsManager)vcs, true);
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Tree.latest.all.select(t|t.label='child').size;"));
            Assert.assertEquals((Object)"changed", (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='child').latest.label;"));
            Assert.assertEquals((Object)2, (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(t|t.label='child').versions.size;"));
            Assert.assertEquals((Object)2, (Object)this.timeAwareEOL("var root = Tree.latest.all.selectOne(t|t.label='root'); var versions : Set; versions.add(root.earliest); versions.add(root.latest); return versions.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("var root = Tree.latest.all.selectOne(t|t.label='root'); var versions : Set; versions.add(root.earliest); versions.add(root.earliest); return versions.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("var root = Tree.latest.all.selectOne(t|t.label='root');var lastUpdate = Tree.latest.all.selectOne(t|t.label='child').latest.time;return root.getOutgoingEdgesWithTypeBetween('children', 0l, lastUpdate).size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("var latestChild = Tree.latest.all.selectOne(t|t.label='child').latest;return latestChild.getIncomingEdgesWithTypeBetween('children', 0l, latestChild.time).size;"));
            return null;
        });
    }
}

