/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.metamodel;

import java.util.Collections;
import java.util.Set;
import org.eclipse.hawk.core.model.IHawkAnnotation;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.modelio.exml.metamodel.AbstractModelioObject;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioClass;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioDataType;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MAttribute;

public class ModelioAttribute
extends AbstractModelioObject
implements IHawkAttribute {
    private final ModelioClass mClass;
    private final MAttribute mAttr;

    public ModelioAttribute(ModelioClass mc, MAttribute mattr) {
        this.mClass = mc;
        this.mAttr = mattr;
    }

    public MAttribute getRawAttribute() {
        return this.mAttr;
    }

    public String getName() {
        return this.mAttr.getName();
    }

    public boolean isMany() {
        return this.mAttr.getIsMany();
    }

    public boolean isUnique() {
        return this.mAttr.getIsUnique();
    }

    public boolean isOrdered() {
        return this.mAttr.getIsOrdered();
    }

    public boolean isRoot() {
        return false;
    }

    public String getUri() {
        return String.valueOf(this.mClass.getPackageNSURI()) + "#" + this.getUriFragment();
    }

    public String getUriFragment() {
        return this.mAttr.getId();
    }

    public boolean isFragmentUnique() {
        return true;
    }

    public boolean isSet(IHawkStructuralFeature hsf) {
        switch (hsf.getName()) {
            case "name": {
                return true;
            }
        }
        return false;
    }

    public Object get(IHawkAttribute attr) {
        switch (attr.getName()) {
            case "name": {
                return this.mAttr.getName();
            }
        }
        return null;
    }

    public Object get(IHawkReference ref, boolean b) {
        return null;
    }

    public boolean isDerived() {
        return false;
    }

    public Set<IHawkAnnotation> getAnnotations() {
        return Collections.emptySet();
    }

    public IHawkClassifier getType() {
        if (this.mAttr.getMDataType() != null) {
            return new ModelioDataType(this.mClass.getPackage().getResource().getMetaPackage(), this.mAttr.getMDataType());
        }
        return this.mClass.getPackage().getResource().getStringDataType();
    }

    @Override
    public String getExml() {
        return this.mAttr.getExml();
    }

    public String toString() {
        return "ModelioAttribute [getName()=" + this.getName() + ", isMany()=" + this.isMany() + ", isUnique()=" + this.isUnique() + ", isOrdered()=" + this.isOrdered() + ", getType()=" + this.getType() + "]";
    }

    public Object getEObject() {
        return null;
    }
}

