/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hawk.core.IHawkFactory;
import org.eclipse.hawk.core.IHawkPlugin;
import org.eclipse.hawk.core.IModelUpdater;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.ui2.Activator;
import org.eclipse.hawk.ui2.preferences.HawkPluginSelectionBlock;
import org.eclipse.hawk.ui2.util.HUIManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class HWizardPage
extends WizardPage {
    private static final Pattern PATTERN = Pattern.compile("[^A-Za-z0-9_]");
    private static final String HAWK_CONNECT_WARNING = "Index storage folder must be empty -- Hawk will try to connect to an existing Hawk in this location";
    private Text minDelayText;
    private Text maxDelayText;
    private Text nameText;
    private Text folderText;
    private Combo backendNameText;
    private Combo updaterNameText;
    private Combo factoryNameText;
    private Text remoteLocationText;
    private boolean isNew;
    private HUIManager hminstance;
    private Map<String, IHawkFactory> factories;
    private Map<String, IGraphDatabase> backends;
    private Map<String, IModelUpdater> updaters;
    private HawkPluginSelectionBlock pluginSelectionBlock;
    private String basePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString();

    public HWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("New Hawk Instance");
        this.setDescription("This wizard creates a new Hawk Instance to index model repositories.");
    }

    public void createControl(Composite parent) {
        this.hminstance = HUIManager.getInstance();
        TabFolder tabFolder = new TabFolder(parent, 2048);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem mainConfigTab = new TabItem(tabFolder, 0);
        mainConfigTab.setText("Base Configuration");
        mainConfigTab.setControl((Control)this.createBaseConfig((Composite)tabFolder));
        TabItem advancedTab = new TabItem(tabFolder, 0);
        advancedTab.setText("Advanced");
        advancedTab.setControl((Control)this.createAdvancedConfig((Composite)tabFolder));
    }

    private Composite createAdvancedConfig(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        this.pluginSelectionBlock = new HawkPluginSelectionBlock();
        this.pluginSelectionBlock.createControl(container);
        this.pluginSelectionBlock.addCheckStateListener(ev -> this.dialogChanged());
        return container;
    }

    private Composite createBaseConfig(Composite parent) {
        ScrolledComposite scrolled = new ScrolledComposite(parent, 512);
        scrolled.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite container = new Composite((Composite)scrolled, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("&Name:");
        this.nameText = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd);
        DialogChangeModifyListener dialogChangeListener = new DialogChangeModifyListener();
        this.nameText.addModifyListener((ModifyListener)dialogChangeListener);
        label = new Label(container, 0);
        label.setText("Instance type:");
        this.factoryNameText = new Combo(container, 8);
        this.factories = this.hminstance.getHawkFactoryInstances();
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.factoryNameText.setLayoutData((Object)gd);
        List sortedFactories = this.factories.values().stream().map(IHawkPlugin::getHumanReadableName).collect(Collectors.toList());
        Collections.sort(sortedFactories);
        for (String factory : sortedFactories) {
            this.factoryNameText.add(factory);
        }
        this.factoryNameText.select(0);
        this.factoryNameText.addSelectionListener((SelectionListener)new DialogChangeSelectionListener());
        label = new Label(container, 0);
        label.setText("&Local storage folder:");
        this.folderText = new Text(container, 2052);
        gd = new GridData(768);
        this.folderText.setLayoutData((Object)gd);
        this.folderText.addModifyListener((ModifyListener)dialogChangeListener);
        Button button = new Button(container, 8);
        gd = new GridData(768);
        button.setLayoutData((Object)gd);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("Remote location:");
        this.remoteLocationText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.remoteLocationText.setLayoutData((Object)gd);
        this.remoteLocationText.setText("http://localhost:8080/thrift/hawk/tuple");
        this.remoteLocationText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                HWizardPage.this.updatePlugins();
            }
        });
        label = new Label(container, 0);
        label.setText("Updater:");
        this.updaters = this.hminstance.getModelUpdaterInstances();
        this.updaterNameText = new Combo(container, 8);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.updaterNameText.setLayoutData((Object)gd);
        List<String> updaterNames = this.getUpdaterNames();
        for (String db : updaterNames) {
            this.updaterNameText.add(db);
        }
        this.updaterNameText.select(0);
        label = new Label(container, 0);
        label.setText("Back-end:");
        this.backends = this.hminstance.getBackendInstances();
        this.backendNameText = new Combo(container, 8);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.backendNameText.setLayoutData((Object)gd);
        List<String> backendNames = this.getBackendNames();
        for (String db : backendNames) {
            this.backendNameText.add(db);
        }
        this.backendNameText.select(0);
        label = new Label(container, 0);
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        label.setText("Min/Max Delay:");
        Composite cDelayRow = new Composite(container, 0);
        gd = new GridData(4, 128, true, true);
        gd.horizontalSpan = 2;
        cDelayRow.setLayoutData((Object)gd);
        FillLayout cDelayRowLayout = new FillLayout();
        cDelayRow.setLayout((Layout)cDelayRowLayout);
        this.minDelayText = new Text(cDelayRow, 2052);
        this.minDelayText.setText("5000");
        this.minDelayText.setToolTipText("Minimum delay between periodic synchronisations in milliseconds.");
        this.minDelayText.addModifyListener((ModifyListener)dialogChangeListener);
        this.maxDelayText = new Text(cDelayRow, 2052);
        this.maxDelayText.setText("512000");
        this.maxDelayText.setToolTipText("Maximum delay between periodic synchronisations in milliseconds (0 disables periodic synchronisations).");
        this.maxDelayText.addModifyListener((ModifyListener)dialogChangeListener);
        this.initialize();
        this.dialogChanged();
        scrolled.setContent((Control)container);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        scrolled.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)scrolled);
        return scrolled;
    }

    private List<String> getBackendNames() {
        List<String> backendNames = this.backends.values().stream().map(IHawkPlugin::getHumanReadableName).collect(Collectors.toList());
        Collections.sort(backendNames);
        return backendNames;
    }

    private List<String> getUpdaterNames() {
        List<String> updaterNames = this.updaters.values().stream().map(IHawkPlugin::getHumanReadableName).collect(Collectors.toList());
        Collections.sort(updaterNames);
        return updaterNames;
    }

    private void initialize() {
        this.nameText.setText("myhawk");
        this.folderText.setText(String.valueOf(this.basePath) + File.separator + "myhawk");
    }

    private void handleBrowse() {
        DirectoryDialog dd = new DirectoryDialog(this.getShell(), 4096);
        dd.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString());
        dd.setMessage("Select a folder where the index files will be stored");
        dd.setText("Select a directory");
        String result = dd.open();
        if (result != null) {
            this.folderText.setText(result);
        }
    }

    private void dialogChanged() {
        int maxDelay;
        int minDelay;
        IHawkFactory factory = this.getSelectedFactory();
        this.remoteLocationText.setEnabled(factory.isRemote());
        if (this.getHawkName().trim().equals("")) {
            this.updateStatus("Hawk name must not be empty.");
            return;
        }
        Matcher m = PATTERN.matcher(this.getHawkName());
        if (m.find()) {
            this.updateStatus("Hawk name must contain only letters, numbers or underscores.");
            return;
        }
        if (this.getContainerName().length() == 0) {
            this.updateStatus("Indexer name/folder must be specified");
            return;
        }
        if (this.getContainerName().length() == 0) {
            this.updateStatus("Index storage folder must be specified");
            return;
        }
        File f = new File(this.getContainerName());
        if (f.exists()) {
            if (f.isDirectory() && f.listFiles().length > 0) {
                this.updateStatus(HAWK_CONNECT_WARNING);
                return;
            }
            this.updateStatus("A file already exists in the specified path - please use a different path");
            return;
        }
        if (!f.getParentFile().canWrite()) {
            this.updateStatus("Index storage folder cannot be created");
        }
        if (this.backendNameText.getText().equals("")) {
            this.updateStatus("Hawk back-end needs to be selected");
            return;
        }
        try {
            minDelay = Integer.parseInt(this.minDelayText.getText());
        }
        catch (NumberFormatException ex) {
            this.updateStatus("Minimum delay must be an integer");
            return;
        }
        try {
            maxDelay = Integer.parseInt(this.maxDelayText.getText());
        }
        catch (NumberFormatException ex) {
            this.updateStatus("Maximum delay must be an integer");
            return;
        }
        if (minDelay > maxDelay) {
            this.updateStatus("Minimum delay must be less than or equal to maximum delay");
            return;
        }
        if (minDelay < 0) {
            this.updateStatus("Minimum delay must be greater than or equal to zero");
            return;
        }
        if (maxDelay < 0) {
            this.updateStatus("Maximum delay must be greater than or equal to zero");
            return;
        }
        if (this.pluginSelectionBlock != null) {
            if (this.pluginSelectionBlock.getMetamodelTableViewer().getCheckedElements().length == 0) {
                this.updateStatus("At least one metamodel parser must be enabled");
                return;
            }
            if (this.pluginSelectionBlock.getModelTableViewer().getCheckedElements().length == 0) {
                this.updateStatus("At least one model parser must be enabled");
                return;
            }
            if (this.pluginSelectionBlock.getQueryEngineTableViewer().getCheckedElements().length == 0) {
                this.updateStatus("At least one query engine must be enabled");
                return;
            }
        }
        this.updateStatus(null);
    }

    private void updatePlugins() {
        if (this.pluginSelectionBlock != null) {
            this.pluginSelectionBlock.update(this.getAvailablePlugins());
        }
        this.update(this.updaterNameText, IHawkPlugin.Category.MODEL_UPDATER);
        this.update(this.backendNameText, IHawkPlugin.Category.BACKEND);
    }

    protected boolean containsAny(List<String> enabledPlugins, Set<String> filter) {
        filter.retainAll(enabledPlugins);
        return !filter.isEmpty();
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null || message.equals(HAWK_CONNECT_WARNING));
        this.isNew = message == null ? true : !message.equals(HAWK_CONNECT_WARNING);
    }

    protected void update(Combo combo, IHawkPlugin.Category category) {
        try {
            List<Object> plugins = this.getAvailablePlugins();
            plugins = plugins.parallelStream().filter(p -> p.getCategory().equals((Object)category)).collect(Collectors.toList());
            List newNames = plugins.parallelStream().map(IHawkPlugin::getHumanReadableName).collect(Collectors.toList());
            if (!newNames.equals(Arrays.asList(combo.getItems()))) {
                combo.removeAll();
                for (String s : newNames) {
                    combo.add(s);
                }
                if (newNames.size() > 0) {
                    combo.select(0);
                }
            }
        }
        catch (Exception ex) {
            Activator.logError("Could not refresh " + category.name() + " list", ex);
        }
    }

    private List<IHawkPlugin> getAvailablePlugins() {
        List plugins;
        try {
            IHawkFactory factory = this.getSelectedFactory();
            plugins = factory.listPlugins(this.remoteLocationText.getText());
            if (plugins == null) {
                plugins = HManager.getInstance().getAvailablePlugins();
            }
        }
        catch (Exception e) {
            plugins = Collections.emptyList();
        }
        return plugins;
    }

    public String getContainerName() {
        return this.folderText.getText();
    }

    public String getDBID() {
        return this.backends.entrySet().stream().filter(e -> ((IGraphDatabase)e.getValue()).getHumanReadableName().equals(this.backendNameText.getText())).findFirst().map(e -> (String)e.getKey()).get();
    }

    public String getUpdater() {
        return this.updaters.entrySet().stream().filter(e -> ((IModelUpdater)e.getValue()).getHumanReadableName().equals(this.updaterNameText.getText())).findFirst().map(e -> (String)e.getKey()).get();
    }

    public String getHawkName() {
        return this.nameText.getText();
    }

    protected String getSelectedFactoryPluginId() {
        String selected = this.factoryNameText.getText();
        List plugins = this.factories.entrySet().stream().filter(e -> selected.equals(((IHawkFactory)e.getValue()).getHumanReadableName())).map(m -> (String)m.getKey()).collect(Collectors.toList());
        return (String)plugins.get(0);
    }

    protected IHawkFactory getSelectedFactory() {
        return this.factories.get(this.getSelectedFactoryPluginId());
    }

    public IHawkFactory getFactory() throws CoreException {
        return this.hminstance.createHawkFactory(this.getSelectedFactoryPluginId());
    }

    public String getLocation() {
        return this.remoteLocationText.getText();
    }

    public int getMaxDelay() {
        try {
            return Integer.parseInt(this.maxDelayText.getText());
        }
        catch (Exception e) {
            return 512000;
        }
    }

    public int getMinDelay() {
        try {
            return Integer.parseInt(this.minDelayText.getText());
        }
        catch (Exception e) {
            return 5000;
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    protected List<String> getSelectedAdvancedPlugins() {
        ArrayList<String> selected = new ArrayList<String>();
        selected.addAll(this.pluginSelectionBlock.getAllChecked());
        selected.add(this.getUpdater());
        return selected;
    }

    private final class DialogChangeModifyListener
    implements ModifyListener {
        private DialogChangeModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            HWizardPage.this.dialogChanged();
        }
    }

    private final class DialogChangeSelectionListener
    extends SelectionAdapter {
        private DialogChangeSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            HWizardPage.this.updatePlugins();
            HWizardPage.this.dialogChanged();
        }
    }
}

