/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.modelio;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.MetamodelNode;
import org.eclipse.hawk.graph.TypeNode;
import org.eclipse.hawk.graph.syncValidationListener.SyncValidationListener;
import org.eclipse.hawk.integration.tests.IntegrationTestSuite;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.modelio.ModelioModelSupportFactory;
import org.eclipse.hawk.modelio.exml.listeners.ModelioGraphChangeListener;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioPackage;
import org.eclipse.hawk.modelio.exml.metamodel.register.MetamodelRegister;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class ModelioMetamodelPopulationTest
extends ModelIndexingTest {
    @Rule
    public ModelIndexingTest.GraphChangeListenerRule<SyncValidationListener> validationListener = new ModelIndexingTest.GraphChangeListenerRule((ModelIndexingTest)this, (IGraphChangeListener)new SyncValidationListener());
    @Rule
    public ModelIndexingTest.GraphChangeListenerRule<ModelioGraphChangeListener> modelioListener = new ModelIndexingTest.GraphChangeListenerRule((ModelIndexingTest)this, (IGraphChangeListener)new ModelioGraphChangeListener());

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return IntegrationTestSuite.caseParams();
    }

    public ModelioMetamodelPopulationTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf, new ModelioModelSupportFactory());
    }

    @Override
    public void setup() throws Throwable {
        super.setup();
        this.indexer.registerMetamodels(new File[]{new File(new File(this.baseDir, "resources/metamodels/"), "metamodel_descriptor.xml")});
    }

    @Test
    public void metamodel() throws Exception {
        int nTypes = 0;
        Collection pkgs = MetamodelRegister.INSTANCE.getRegisteredPackages();
        Throwable throwable = null;
        Object var4_5 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            nTypes = this.visitPackages(nTypes, pkgs);
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((long)409L, (long)nTypes);
    }

    protected int visitPackages(int nTypes, Collection<ModelioPackage> pkgs) {
        GraphWrapper gw = new GraphWrapper(this.db);
        for (ModelioPackage mpkg : pkgs) {
            MetamodelNode mmNode = gw.getMetamodelNodeByNsURI(mpkg.getNsURI());
            HashSet<String> types = new HashSet<String>();
            for (TypeNode typeNode : mmNode.getTypes()) {
                types.add(typeNode.getTypeName());
                ++nTypes;
            }
            for (IHawkClassifier mc : mpkg.getClasses()) {
                Assert.assertTrue((boolean)types.contains(mc.getName()));
            }
        }
        return nTypes;
    }

    @Test
    public void zoo() throws Throwable {
        this.requestFolderIndex(new File(this.baseDir, "resources/models/zoo"));
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.validationListener.getListener());
            Assert.assertEquals((Object)6, (Object)this.eol("return Class.all.size;"));
            return null;
        });
    }
}

