/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.wrappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeReference;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.graph.FileNode;
import org.eclipse.hawk.graph.ModelElementNode;

public class FileNodeWrapper
implements IGraphNodeReference {
    private FileNode fileNode;
    private EOLQueryEngine model;

    public FileNodeWrapper(FileNode fileNode, EOLQueryEngine eolQueryEngine) {
        this.fileNode = fileNode;
        this.model = eolQueryEngine;
    }

    public String getId() {
        return this.fileNode.getNode().getId().toString();
    }

    public IGraphNode getNode() {
        return this.fileNode.getNode();
    }

    public IQueryEngine getContainerModel() {
        return this.model;
    }

    public String getTypeName() {
        return "_hawkFileNode";
    }

    public String getPath() {
        return this.fileNode.getFilePath();
    }

    public String getRepository() {
        return this.fileNode.getRepositoryURL();
    }

    public List<IGraphNodeReference> getRoots() {
        ArrayList<IGraphNodeReference> results = new ArrayList<IGraphNodeReference>();
        for (ModelElementNode n : this.fileNode.getRootModelElements()) {
            results.add(this.model.wrap(n.getNode()));
        }
        return results;
    }

    public List<IGraphNodeReference> getContents() {
        ArrayList<IGraphNodeReference> results = new ArrayList<IGraphNodeReference>();
        for (ModelElementNode n : this.fileNode.getModelElements()) {
            results.add(this.model.wrap(n.getNode()));
        }
        return results;
    }

    public String toString() {
        return String.format("FNW|id:%s|type:%s", this.getId(), this.getTypeName());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileNode, this.model});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileNodeWrapper other = (FileNodeWrapper)obj;
        return Objects.equals(this.fileNode, other.fileNode) && Objects.equals((Object)this.model, (Object)other.model);
    }
}

