/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsChangeType;
import org.eclipse.hawk.core.VcsCommit;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.VcsRepositoryDelta;

public class HTTPManager
implements IVcsManager {
    private static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    private static final String FIRST_REV = "0";
    private boolean isActive;
    private IConsole console;
    private URI repositoryURI;
    private String username;
    private String password;
    private String lastETag;
    private String lastDigest;
    private byte[] lastDigestedResponse;
    private String lastDelta;
    private String lastFilename;
    private IModelIndexer indexer;
    private boolean isFrozen = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCurrentRevision() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CloseableHttpClient cl = this.createClient();){
            HttpHead headRequest = new HttpHead(this.repositoryURI);
            this.decorateCurrentRevisionRequest((HttpRequestBase)headRequest);
            Throwable throwable3 = null;
            Throwable throwable2 = null;
            try {
                CloseableHttpResponse response2;
                block22: {
                    String string;
                    response2 = cl.execute((HttpUriRequest)headRequest);
                    try {
                        String headRevision = this.getRevision((HttpResponse)response2, false);
                        if (headRevision == null) break block22;
                        string = headRevision;
                        if (response2 == null) return string;
                    }
                    catch (Throwable throwable4) {
                        if (response2 == null) throw throwable4;
                        response2.close();
                        throw throwable4;
                    }
                    response2.close();
                    return string;
                }
                if (response2 != null) {
                    response2.close();
                }
            }
            catch (Throwable throwable5) {
                if (throwable3 == null) {
                    throwable3 = throwable5;
                    throw throwable3;
                }
                if (throwable3 == throwable5) throw throwable3;
                throwable3.addSuppressed(throwable5);
                throw throwable3;
            }
            HttpGet getRequest = new HttpGet(this.repositoryURI);
            this.decorateCurrentRevisionRequest((HttpRequestBase)getRequest);
            throwable2 = null;
            Object var7_12 = null;
            try {
                CloseableHttpResponse response;
                block24: {
                    String string;
                    response = cl.execute((HttpUriRequest)getRequest);
                    try {
                        String getRev = this.getRevision((HttpResponse)response, true);
                        if (getRev == null) break block24;
                        string = getRev;
                        if (response == null) return string;
                    }
                    catch (Throwable throwable6) {
                        if (response == null) throw throwable6;
                        response.close();
                        throw throwable6;
                    }
                    response.close();
                    return string;
                }
                if (response == null) return "1";
                response.close();
                return "1";
            }
            catch (Throwable throwable7) {
                if (throwable2 == null) {
                    throwable2 = throwable7;
                    throw throwable2;
                }
                if (throwable2 == throwable7) throw throwable2;
                throwable2.addSuppressed(throwable7);
                throw throwable2;
            }
        }
        catch (Throwable throwable8) {
            if (throwable == null) {
                throwable = throwable8;
                throw throwable;
            }
            if (throwable == throwable8) throw throwable;
            throwable.addSuppressed(throwable8);
            throw throwable;
        }
    }

    protected void decorateCurrentRevisionRequest(HttpRequestBase request) {
        if (this.lastETag != null) {
            request.setHeader("ETag", this.lastETag);
            request.setHeader("If-None-Match", "*");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getRevision(HttpResponse response, boolean useDigest) {
        Header etagHeader;
        if (response.getStatusLine().getStatusCode() == 304) {
            return this.lastETag;
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            return FIRST_REV;
        }
        Header cdHeader = response.getFirstHeader(HEADER_CONTENT_DISPOSITION);
        if (cdHeader != null) {
            this.lastFilename = Arrays.stream(cdHeader.getElements()).map(e -> e.getParameterByName("filename")).filter(Objects::nonNull).map(NameValuePair::getValue).findFirst().orElse(null);
        }
        if ((etagHeader = response.getFirstHeader("ETag")) != null) {
            this.lastETag = etagHeader.getValue();
            return this.lastETag;
        }
        Header lmHeader = response.getFirstHeader("Last-Modified");
        if (lmHeader != null) {
            Date lmDate = DateUtils.parseDate((String)lmHeader.getValue());
            return String.valueOf(lmDate.getTime());
        }
        if (!useDigest) return null;
        try {
            ByteArrayOutputStream bos;
            MessageDigest md;
            block21: {
                md = MessageDigest.getInstance("SHA");
                bos = new ByteArrayOutputStream();
                Throwable throwable = null;
                Object var9_13 = null;
                try {
                    InputStream is = response.getEntity().getContent();
                    try {
                        try (DigestInputStream dis = new DigestInputStream(is, md);){
                            IOUtils.copy((InputStream)dis, (OutputStream)bos);
                        }
                        if (is == null) break block21;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            this.lastDigestedResponse = bos.toByteArray();
            this.lastDigest = Base64.getEncoder().encodeToString(md.digest());
            return this.lastDigest;
        }
        catch (NoSuchAlgorithmException ex) {
            this.console.printerrln((Throwable)ex);
            return null;
        }
        catch (IOException ex) {
            this.console.printerrln((Throwable)ex);
        }
        return null;
    }

    protected CloseableHttpClient createClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.username != null) {
            BasicCredentialsProvider credProvider = new BasicCredentialsProvider();
            credProvider.setCredentials(new AuthScope(new HttpHost(this.repositoryURI.getHost())), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credProvider);
        }
        builder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        return builder.build();
    }

    public String getFirstRevision() throws Exception {
        return FIRST_REV;
    }

    public List<VcsCommitItem> getDelta(String endRevision) throws Exception {
        return this.getDelta(FIRST_REV, endRevision).getCompactedCommitItems();
    }

    public VcsRepositoryDelta getDelta(String startRevision, String endRevision) throws Exception {
        VcsRepositoryDelta delta;
        if (this.lastDelta == null || !this.lastDelta.equals(endRevision)) {
            VcsCommit c = new VcsCommit();
            c.setAuthor("Unknown");
            c.setJavaDate(new Date());
            c.setMessage("HTTP file changed: " + this.repositoryURI);
            c.setRevision(endRevision);
            VcsCommitItem ci = new VcsCommitItem();
            Path path = Paths.get(this.repositoryURI.getPath(), new String[0]);
            if (this.lastFilename != null && !path.endsWith(this.lastFilename)) {
                path = Paths.get(path.toString(), this.lastFilename);
            }
            ci.setPath(path.toString());
            ci.setChangeType(VcsChangeType.UPDATED);
            ci.setCommit(c);
            c.getItems().add(ci);
            delta = new VcsRepositoryDelta(Collections.singleton(c));
        } else {
            delta = new VcsRepositoryDelta(Collections.emptyList());
        }
        delta.setManager((IVcsManager)this);
        this.lastDelta = endRevision;
        return delta;
    }

    /*
     * Loose catch block
     */
    public File importFile(String revision, String path, File temp) {
        if (revision != null && revision.equals(this.lastDigest)) {
            try {
                Throwable throwable = null;
                Object var5_10 = null;
                try (ByteArrayInputStream bis = new ByteArrayInputStream(this.lastDigestedResponse);){
                    Files.copy(bis, temp.toPath(), new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.console.printerrln((Throwable)e);
            }
        } else {
            try {
                Throwable e = null;
                Object var5_12 = null;
                try (CloseableHttpClient cl = this.createClient();){
                    File file;
                    CloseableHttpResponse response;
                    Throwable throwable;
                    block35: {
                        throwable = null;
                        Object var8_18 = null;
                        response = cl.execute((HttpUriRequest)new HttpGet(this.repositoryURI));
                        Files.copy(response.getEntity().getContent(), temp.toPath(), new CopyOption[0]);
                        file = temp;
                        if (response == null) break block35;
                        response.close();
                    }
                    return file;
                    {
                        catch (Throwable throwable3) {
                            try {
                                if (response != null) {
                                    response.close();
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                this.console.printerrln((Throwable)e);
            }
        }
        return null;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void init(String vcsloc, IModelIndexer indexer) throws URISyntaxException {
        this.console = indexer.getConsole();
        this.repositoryURI = new URI(vcsloc);
        this.indexer = indexer;
    }

    public void run() throws Exception {
        try {
            ICredentialsStore credStore = this.indexer.getCredentialsStore();
            if (this.username != null) {
                this.setCredentials(this.username, this.password, credStore);
            } else {
                ICredentialsStore.Credentials credentials = credStore.get(this.repositoryURI.toString());
                if (credentials != null) {
                    this.username = credentials.getUsername();
                    this.password = credentials.getPassword();
                } else {
                    this.console.printerrln("No username/password recorded for the repository " + this.repositoryURI);
                    this.username = "";
                    this.password = "";
                }
            }
            this.isActive = true;
        }
        catch (Exception e) {
            this.console.printerrln("exception in svnmanager run():");
            this.console.printerrln((Throwable)e);
        }
    }

    public void shutdown() {
        this.repositoryURI = null;
        this.console = null;
    }

    public String getLocation() {
        return this.repositoryURI.toString();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setCredentials(String username, String password, ICredentialsStore credStore) {
        if (!(username == null || password == null || this.repositoryURI == null || username.equals(this.username) && password.equals(this.password))) {
            try {
                credStore.put(this.repositoryURI.toString(), new ICredentialsStore.Credentials(username, password));
            }
            catch (Exception e) {
                this.console.printerrln("Could not save new username/password");
                this.console.printerrln((Throwable)e);
            }
        }
        this.username = username;
        this.password = password;
    }

    public String getHumanReadableName() {
        return "HTTP Monitor";
    }

    public boolean isAuthSupported() {
        return true;
    }

    public boolean isPathLocationAccepted() {
        return false;
    }

    public boolean isURLLocationAccepted() {
        return true;
    }

    public String getRepositoryPath(String rawPath) {
        String sRepositoryURI = this.repositoryURI.toString();
        if (rawPath.startsWith(sRepositoryURI)) {
            return rawPath.substring(sRepositoryURI.length());
        }
        return rawPath;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public void setFrozen(boolean f) {
        this.isFrozen = f;
    }

    public String getDefaultLocation() {
        return "http://host:port/path";
    }
}

