/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.dialog;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.osgiserver.HModelSchedulingRule;
import org.eclipse.hawk.ui2.Activator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class HQueryDialog
extends TitleAreaDialog
implements IStateListener {
    private static final String QUERY_IS_FILE = "FILE QUERY:\n";
    private static final String QUERY_IS_EDITOR = "EDITOR QUERY:\n";
    private static final String QUERY_EDITED = "[query has been edited since last results]";
    private HModel index;
    private IProgressMonitor currentQueryMonitor;
    private StyledText queryField;
    private StyledText resultField;
    private StyledText contextRepo;
    private StyledText contextFiles;
    private StyledText defaultNamespaces;
    private Button enableFullTraversalScopingButton;
    private Button queryButton;
    private Combo queryLanguage;
    private StyledText subtreeText;
    private Button useDerivedForSubtreeButton;
    private Button fileFirstButton;
    private TabFolder tabFolder;
    private Map<String, IQueryEngine> queryLanguageInstances;

    public HQueryDialog(Shell parentShell, HModel in) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() & 0xFFFFFFBF);
        this.index = in;
        this.index.getHawk().getModelIndexer().addStateListener((IStateListener)this);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button cancel = this.getButton(0);
        cancel.setText("Done");
        this.setButtonLayoutData(cancel);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        this.setTitle("Query Hawk index");
        this.setMessage("Enter a query (either as text or as a file) and click [Run Query] to get a result.");
        this.queryLanguageInstances = HManager.getInstance().getQueryLanguageInstances();
        Composite container = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        container.setLayout((Layout)formLayout);
        container.setLayoutData((Object)new GridData(1808));
        this.tabFolder = new TabFolder(container, 2048);
        this.createTab("Query", cmp -> {
            this.createQueryArea((Composite)cmp);
            this.createQueryLanguageSelector((Composite)cmp);
            return null;
        });
        this.createTab("Path-based scope", cmp -> {
            this.createContextRepository((Composite)cmp);
            this.createContextFiles((Composite)cmp);
            return null;
        });
        this.createTab("Tree-based scope", cmp -> {
            this.createSubtree((Composite)cmp);
            return null;
        });
        this.createTab("Namespaces", cmp -> {
            this.createDefaultNamespaces((Composite)cmp);
            return null;
        });
        this.createTab("Traversal", cmp -> {
            this.createFullTraversal((Composite)cmp);
            return null;
        });
        FormData tabFolderFD = new FormData();
        tabFolderFD.left = new FormAttachment(0, 0);
        tabFolderFD.right = new FormAttachment(100, 0);
        this.tabFolder.setLayoutData((Object)tabFolderFD);
        this.createButtons(container);
        return container;
    }

    private void createTab(String tabText, Function<Composite, Void> tabFiller) {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(tabText);
        Composite cmp = new Composite((Composite)this.tabFolder, 0);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 20;
        cmp.setLayout((Layout)layout);
        tabFiller.apply(cmp);
        tabItem.setControl((Control)cmp);
    }

    protected void createSubtree(Composite container) {
        Label lSubtree = new Label(container, 16448);
        lSubtree.setText("Subtree root context (for fragmented models - path within repository):");
        FormData lSubtreeFD = new FormData();
        lSubtreeFD.left = new FormAttachment(5, 0);
        lSubtreeFD.right = new FormAttachment(95, 0);
        lSubtreeFD.top = new FormAttachment(5, 0);
        lSubtree.setLayoutData((Object)lSubtreeFD);
        this.subtreeText = new StyledText(container, 2816);
        FormData subtreeTextFD = new FormData();
        subtreeTextFD.left = new FormAttachment(5, 0);
        subtreeTextFD.right = new FormAttachment(95, 0);
        subtreeTextFD.height = 60;
        subtreeTextFD.top = new FormAttachment((Control)lSubtree, 10);
        this.subtreeText.setLayoutData((Object)subtreeTextFD);
        Label lSubtreeDerived = new Label(container, 16448);
        lSubtreeDerived.setText("Use derived edges to speed up Type.all in subtree queries:");
        FormData lSubtreeDerivedFD = new FormData();
        lSubtreeDerivedFD.left = new FormAttachment(5, 0);
        lSubtreeDerivedFD.top = new FormAttachment((Control)this.subtreeText, 10);
        lSubtreeDerived.setLayoutData((Object)lSubtreeDerivedFD);
        this.useDerivedForSubtreeButton = new Button(container, 32);
        FormData useDerivedFD = new FormData();
        useDerivedFD.left = new FormAttachment((Control)lSubtreeDerived, 5);
        useDerivedFD.top = new FormAttachment((Control)this.subtreeText, 10);
        this.useDerivedForSubtreeButton.setLayoutData((Object)useDerivedFD);
    }

    protected void createButtons(Composite container) {
        this.queryButton = new Button(container, 8);
        this.queryButton.setText("Run Query");
        FormData queryButtonFD = new FormData();
        queryButtonFD.left = new FormAttachment(6, 0);
        queryButtonFD.right = new FormAttachment(34, 0);
        queryButtonFD.top = new FormAttachment((Control)this.tabFolder, 20);
        this.queryButton.setLayoutData((Object)queryButtonFD);
        this.queryButton.addSelectionListener((SelectionListener)new QueryExecutionSelectionAdapter());
        Button resetButton = new Button(container, 8);
        resetButton.setText("Reset Query");
        FormData resetButtonFD = new FormData();
        resetButtonFD.left = new FormAttachment(36, 0);
        resetButtonFD.right = new FormAttachment(64, 0);
        resetButtonFD.top = new FormAttachment((Control)this.tabFolder, 20);
        resetButton.setLayoutData((Object)resetButtonFD);
        resetButton.addSelectionListener((SelectionListener)new ResetButtonSelectionAdapter());
        Button syncButton = new Button(container, 8);
        syncButton.setText("Request Immediate Sync");
        syncButton.setImage(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), (IPath)new Path("icons/refresh.gif"), null)).createImage());
        FormData syncButtonFD = new FormData();
        syncButtonFD.left = new FormAttachment(66, 0);
        syncButtonFD.right = new FormAttachment(94, 0);
        syncButtonFD.top = new FormAttachment((Control)this.tabFolder, 20);
        syncButton.setLayoutData((Object)syncButtonFD);
        syncButton.addSelectionListener((SelectionListener)new SyncSelectionAdapter());
    }

    protected void createDefaultNamespaces(Composite container) {
        Label lDefaultNamespaces = new Label(container, 8);
        lDefaultNamespaces.setText("Default Namespaces (comma separated):");
        FormData lDefaultNamespacesFD = new FormData();
        lDefaultNamespacesFD.left = new FormAttachment(5, 0);
        lDefaultNamespacesFD.right = new FormAttachment(95, 0);
        lDefaultNamespacesFD.top = new FormAttachment(5, 0);
        lDefaultNamespaces.setLayoutData((Object)lDefaultNamespacesFD);
        this.defaultNamespaces = new StyledText(container, 2816);
        FormData defaultNamespacesFD = new FormData();
        defaultNamespacesFD.left = new FormAttachment(5, 0);
        defaultNamespacesFD.top = new FormAttachment((Control)lDefaultNamespaces, 10);
        defaultNamespacesFD.right = new FormAttachment(95, 0);
        defaultNamespacesFD.height = 60;
        this.defaultNamespaces.setLayoutData((Object)defaultNamespacesFD);
    }

    protected void createFullTraversal(Composite container) {
        Label lFullTraversal = new Label(container, 16448);
        lFullTraversal.setText("Enable Full Traversal Scoping (may affect performance -- only for scoped queries):");
        FormData lFullTraversalFD = new FormData();
        lFullTraversalFD.left = new FormAttachment(5, 0);
        lFullTraversalFD.top = new FormAttachment((Control)this.defaultNamespaces, 10);
        lFullTraversalFD.width = 700;
        lFullTraversal.setLayoutData((Object)lFullTraversalFD);
        this.enableFullTraversalScopingButton = new Button(container, 32);
        FormData enableFTFD = new FormData();
        enableFTFD.left = new FormAttachment((Control)lFullTraversal, 5);
        enableFTFD.top = new FormAttachment((Control)this.defaultNamespaces, 10);
        this.enableFullTraversalScopingButton.setLayoutData((Object)enableFTFD);
    }

    protected void createContextFiles(Composite container) {
        Label lFiles = new Label(container, 16448);
        lFiles.setText("Context Files (comma separated (partial) matches using * as wildcard):");
        FormData lFilesFD = new FormData();
        lFilesFD.left = new FormAttachment(5, 0);
        lFilesFD.right = new FormAttachment(95, 0);
        lFilesFD.top = new FormAttachment((Control)this.contextRepo, 10);
        lFiles.setLayoutData((Object)lFilesFD);
        this.contextFiles = new StyledText(container, 2816);
        FormData contextFilesFD = new FormData();
        contextFilesFD.left = new FormAttachment(5, 0);
        contextFilesFD.right = new FormAttachment(95, 0);
        contextFilesFD.top = new FormAttachment((Control)lFiles, 10);
        contextFilesFD.height = 60;
        this.contextFiles.setLayoutData((Object)contextFilesFD);
        Label lFileFirst = new Label(container, 64);
        lFileFirst.setText("Start with files rather than types for Type.all (faster for small fragments in large graphs):");
        FormData lFileFirstFD = new FormData();
        lFileFirstFD.left = new FormAttachment(5, 0);
        lFileFirstFD.top = new FormAttachment((Control)this.contextFiles, 10);
        lFileFirst.setLayoutData((Object)lFileFirstFD);
        this.fileFirstButton = new Button(container, 32);
        FormData fileFirstButtonFD = new FormData();
        fileFirstButtonFD.left = new FormAttachment((Control)lFileFirst, 10);
        fileFirstButtonFD.top = new FormAttachment((Control)this.contextFiles, 10);
        this.fileFirstButton.setLayoutData((Object)fileFirstButtonFD);
    }

    protected void createContextRepository(Composite container) {
        Label lRepositories = new Label(container, 16448);
        lRepositories.setText("Context Repositories (comma separated (partial) matches using * as wildcard):");
        FormData lRepositoriesFD = new FormData();
        lRepositoriesFD.left = new FormAttachment(5, 0);
        lRepositoriesFD.top = new FormAttachment(5, 0);
        lRepositoriesFD.right = new FormAttachment(95, 0);
        lRepositories.setLayoutData((Object)lRepositoriesFD);
        this.contextRepo = new StyledText(container, 2816);
        FormData contextRepoFD = new FormData();
        contextRepoFD.left = new FormAttachment(5, 0);
        contextRepoFD.right = new FormAttachment(95, 0);
        contextRepoFD.top = new FormAttachment((Control)lRepositories, 10);
        contextRepoFD.height = 60;
        this.contextRepo.setLayoutData((Object)contextRepoFD);
    }

    protected void createQueryLanguageSelector(Composite container) {
        Label lQueryEngine = new Label(container, 8);
        lQueryEngine.setText("Query Engine:");
        FormData lQueryEngineFD = new FormData();
        lQueryEngineFD.left = new FormAttachment(5, 0);
        lQueryEngineFD.top = new FormAttachment((Control)this.resultField, 14);
        lQueryEngine.setLayoutData((Object)lQueryEngineFD);
        this.queryLanguage = new Combo(container, 8);
        ArrayList languages = new ArrayList(this.index.getKnownQueryLanguages());
        Collections.sort(languages);
        for (String s : languages) {
            this.queryLanguage.add(this.queryLanguageInstances.get(s).getHumanReadableName());
        }
        if (this.queryLanguage.getItems().length > 0) {
            this.queryLanguage.select(0);
        }
        FormData queryLanguageFD = new FormData();
        queryLanguageFD.left = new FormAttachment((Control)lQueryEngine, 10);
        queryLanguageFD.right = new FormAttachment(95, 0);
        queryLanguageFD.top = new FormAttachment((Control)this.resultField, 10);
        this.queryLanguage.setLayoutData((Object)queryLanguageFD);
    }

    protected void createQueryArea(Composite container) {
        Label qLabel = new Label(container, 0);
        qLabel.setText("Query:");
        FormData qLabelFD = new FormData();
        qLabelFD.top = new FormAttachment(5, 0);
        qLabelFD.left = new FormAttachment(5, 0);
        qLabel.setLayoutData((Object)qLabelFD);
        this.queryField = new StyledText(container, 2626);
        FormData queryFieldFD = new FormData();
        queryFieldFD.top = new FormAttachment((Control)qLabel, 10);
        queryFieldFD.left = new FormAttachment(5, 0);
        queryFieldFD.right = new FormAttachment(95, 0);
        queryFieldFD.height = 100;
        this.queryField.setLayoutData((Object)queryFieldFD);
        this.queryField.addModifyListener((ModifyListener)new QueryModifyListener());
        Button editor = new Button(container, 8);
        editor.setText("Query Current Editor");
        editor.addSelectionListener((SelectionListener)new UseEditorSelectionAdapter());
        FormData editorFD = new FormData();
        editorFD.bottom = new FormAttachment((Control)this.queryField, -10);
        editorFD.right = new FormAttachment(95, 0);
        editor.setLayoutData((Object)editorFD);
        Button file = new Button(container, 8);
        file.setText("Query File");
        file.addSelectionListener((SelectionListener)new QueryFileSelectionAdapter());
        FormData fileFD = new FormData();
        fileFD.bottom = new FormAttachment((Control)this.queryField, -10);
        fileFD.right = new FormAttachment((Control)editor, -5);
        file.setLayoutData((Object)fileFD);
        Label rLabel = new Label(container, 0);
        rLabel.setText("Result:");
        FormData rLabelFD = new FormData();
        rLabelFD.left = new FormAttachment(5, 0);
        rLabelFD.top = new FormAttachment((Control)this.queryField, 10);
        rLabel.setLayoutData((Object)rLabelFD);
        this.resultField = new StyledText(container, 2626);
        this.resultField.setEditable(false);
        FormData resultFieldFD = new FormData();
        resultFieldFD.left = new FormAttachment(5, 0);
        resultFieldFD.top = new FormAttachment((Control)rLabel, 10);
        resultFieldFD.right = new FormAttachment(95, 0);
        resultFieldFD.height = queryFieldFD.height;
        this.resultField.setLayoutData((Object)resultFieldFD);
    }

    private String fileQueryBrowse() {
        FileDialog fd = new FileDialog(this.getShell(), 4096);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        File rootFile = root.getLocation().toFile();
        fd.setFilterPath(rootFile.toString());
        fd.setText("Select a file to query");
        return fd.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Query: " + this.index.getName());
    }

    private StyleRange createRedBoldRange(int length) {
        Display display = this.getShell().getDisplay();
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = length;
        styleRange.fontStyle = 1;
        styleRange.foreground = new Color((Device)display, 255, 0, 0);
        return styleRange;
    }

    private StyleRange createBoldRange(int length) {
        Display display = this.getShell().getDisplay();
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = length;
        styleRange.fontStyle = 1;
        styleRange.foreground = new Color((Device)display, 0, 0, 0);
        return styleRange;
    }

    public boolean close() {
        this.index.getHawk().getModelIndexer().removeStateListener((IStateListener)this);
        return super.close();
    }

    public void state(IStateListener.HawkState state) {
        switch (state) {
            case STOPPED: {
                this.updateAsync(IStateListener.HawkState.STOPPED);
                break;
            }
            case RUNNING: {
                this.updateAsync(IStateListener.HawkState.RUNNING);
                break;
            }
            case UPDATING: {
                this.updateAsync(IStateListener.HawkState.UPDATING);
            }
        }
    }

    public void updateAsync(final IStateListener.HawkState s) {
        Display display;
        Shell shell = this.getShell();
        if (shell != null && (display = shell.getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (HQueryDialog.this.queryButton != null) {
                            boolean enable = s == IStateListener.HawkState.RUNNING;
                            HQueryDialog.this.queryButton.setEnabled(enable);
                            if (enable) {
                                HQueryDialog.this.setErrorMessage(null);
                            } else {
                                HQueryDialog.this.setErrorMessage(String.format("The index is %s - querying will be disabled", s.toString().toLowerCase()));
                            }
                        }
                    }
                    catch (Exception e) {
                        Activator.logError(e.getMessage(), e);
                    }
                }
            });
        }
    }

    public void info(String s) {
    }

    public void error(String s) {
    }

    public void removed() {
    }

    protected class QueryExecutionSelectionAdapter
    extends SelectionAdapter {
        protected QueryExecutionSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (HQueryDialog.this.currentQueryMonitor == null) {
                String query = HQueryDialog.this.queryLanguage.getText().trim();
                if (!query.isEmpty()) {
                    String ql = HQueryDialog.this.queryLanguageInstances.values().stream().filter(qlang -> qlang.getHumanReadableName().equals(query)).map(elem -> elem.getType()).findFirst().get();
                    this.runQuery(ql);
                }
            } else {
                HQueryDialog.this.currentQueryMonitor.setCanceled(true);
            }
        }

        protected void runQuery(final String queryLang) {
            final Map<String, Object> context = this.createContext();
            final String queryText = HQueryDialog.this.queryField.getText();
            HQueryDialog.this.resultField.setText("");
            HQueryDialog.this.setMessage("Running query...");
            Job runQueryJob = new Job("Running query in " + HQueryDialog.this.index.getName()){
                private Runnable doCancel;

                protected void canceling() {
                    if (this.doCancel != null) {
                        this.doCancel.run();
                    }
                }

                protected IStatus run(IProgressMonitor monitor) {
                    block5: {
                        context.put("EXEC_CANCEL_CONSUMER", doCancel -> {
                            this.doCancel = doCancel;
                        });
                        Display.getDefault().syncExec(() -> {
                            HQueryDialog.this.currentQueryMonitor = monitor;
                            HQueryDialog.this.queryButton.setText("Stop Query");
                            HQueryDialog.this.getButton(0).setEnabled(false);
                        });
                        long start = System.currentTimeMillis();
                        Object result = null;
                        try {
                            try {
                                result = queryText.startsWith(HQueryDialog.QUERY_IS_EDITOR) ? HQueryDialog.this.index.query(queryText.substring(HQueryDialog.QUERY_IS_EDITOR.length()), queryLang, context) : (queryText.startsWith(HQueryDialog.QUERY_IS_FILE) ? HQueryDialog.this.index.query(new File(queryText.substring(HQueryDialog.QUERY_IS_FILE.length())), queryLang, context) : HQueryDialog.this.index.query(queryText, queryLang, context));
                                Object endResult = result;
                                Display.getDefault().syncExec(() -> {
                                    if (!HQueryDialog.this.resultField.isDisposed()) {
                                        HQueryDialog.this.resultField.setText(endResult != null ? endResult.toString() : "<null> returned (if this unexpected, check console for errors)");
                                    }
                                });
                            }
                            catch (Exception ex) {
                                String error = "Error while running the query: " + ex.getMessage();
                                Activator.logError(error, ex);
                                Display.getDefault().syncExec(() -> {
                                    if (!HQueryDialog.this.resultField.isDisposed()) {
                                        HQueryDialog.this.resultField.setText(error);
                                        HQueryDialog.this.resultField.setStyleRange(HQueryDialog.this.createRedBoldRange(error.length()));
                                    }
                                });
                                Display.getDefault().syncExec((Runnable)new CompletedQueryRunnable(start, result));
                                break block5;
                            }
                        }
                        catch (Throwable throwable) {
                            Display.getDefault().syncExec((Runnable)new CompletedQueryRunnable(start, result));
                            throw throwable;
                        }
                        Display.getDefault().syncExec((Runnable)new CompletedQueryRunnable(start, result));
                    }
                    return new Status(0, this.getBundleName(), "Done");
                }

                private String getBundleName() {
                    return FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName();
                }
            };
            runQueryJob.setRule((ISchedulingRule)new HModelSchedulingRule(HQueryDialog.this.index));
            runQueryJob.schedule();
        }

        protected Map<String, Object> createContext() {
            String sRepo = HQueryDialog.this.contextRepo.getText().trim();
            String sFiles = HQueryDialog.this.contextFiles.getText().trim();
            String defaultNamespace = HQueryDialog.this.defaultNamespaces.getText().trim();
            String sSubtree = HQueryDialog.this.subtreeText.getText().trim();
            boolean bFileFirst = HQueryDialog.this.fileFirstButton.getSelection();
            boolean bFullTraversalScoping = HQueryDialog.this.enableFullTraversalScopingButton.getSelection();
            boolean bSubtreeDerived = HQueryDialog.this.useDerivedForSubtreeButton.getSelection();
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (!sFiles.equals("")) {
                context.put("FILE", sFiles);
            }
            if (!sRepo.equals("")) {
                context.put("REPOSITORY", sRepo);
            }
            if (!defaultNamespace.equals("")) {
                context.put("DEFAULTNAMESPACES", defaultNamespace);
            }
            if (!sSubtree.equals("")) {
                context.put("SUBTREE", sSubtree);
            }
            context.put("FILEFIRST", String.valueOf(bFileFirst));
            context.put("ENABLE_TRAVERSAL_SCOPING", String.valueOf(bFullTraversalScoping));
            context.put("SUBTREE_DERIVEDALLOF", String.valueOf(bSubtreeDerived));
            return context;
        }

        private class CompletedQueryRunnable
        implements Runnable {
            private final Object result;
            private long startMillis;

            public CompletedQueryRunnable(long startMillis, Object result) {
                this.startMillis = startMillis;
                this.result = result;
            }

            @Override
            public void run() {
                boolean bCancelled = HQueryDialog.this.currentQueryMonitor.isCanceled();
                HQueryDialog.this.currentQueryMonitor = null;
                if (HQueryDialog.this.queryButton.isDisposed()) {
                    return;
                }
                HQueryDialog.this.queryButton.setText("Run Query");
                HQueryDialog.this.getButton(0).setEnabled(true);
                long endMillis = System.currentTimeMillis();
                long elapsedMillis = endMillis - this.startMillis;
                if (bCancelled) {
                    HQueryDialog.this.setMessage(String.format("Query cancelled after %d s %d ms", elapsedMillis / 1000L, elapsedMillis % 1000L));
                } else if (this.result instanceof Collection) {
                    HQueryDialog.this.setMessage(String.format("Query returned %d results in %d s %d ms", ((Collection)this.result).size(), elapsedMillis / 1000L, elapsedMillis % 1000L), 0);
                } else {
                    HQueryDialog.this.setMessage(String.format("Query completed in %d s %d ms", elapsedMillis / 1000L, elapsedMillis % 1000L), 0);
                }
            }
        }
    }

    protected class QueryFileSelectionAdapter
    extends SelectionAdapter {
        protected QueryFileSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            String s = HQueryDialog.this.fileQueryBrowse();
            if (s != null) {
                HQueryDialog.this.queryField.setEditable(false);
                HQueryDialog.this.queryField.setText(HQueryDialog.QUERY_IS_FILE + s);
                HQueryDialog.this.queryField.setStyleRange(HQueryDialog.this.createBoldRange(HQueryDialog.QUERY_IS_FILE.length()));
            }
        }
    }

    protected class QueryModifyListener
    implements ModifyListener {
        protected QueryModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String res = HQueryDialog.this.resultField.getText();
            if (!res.startsWith(HQueryDialog.QUERY_EDITED)) {
                HQueryDialog.this.resultField.setText("[query has been edited since last results]\n" + res);
                HQueryDialog.this.resultField.setStyleRange(HQueryDialog.this.createRedBoldRange(HQueryDialog.QUERY_EDITED.length()));
            }
        }
    }

    protected class ResetButtonSelectionAdapter
    extends SelectionAdapter {
        protected ResetButtonSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            HQueryDialog.this.queryField.setText("");
            HQueryDialog.this.queryField.setEditable(true);
            HQueryDialog.this.resultField.setText("");
            HQueryDialog.this.contextFiles.setText("");
        }
    }

    protected class SyncSelectionAdapter
    extends SelectionAdapter {
        protected SyncSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                HQueryDialog.this.index.sync();
            }
            catch (Exception ee) {
                Activator.logError("Failed to invoke manual sync", ee);
            }
        }
    }

    protected class UseEditorSelectionAdapter
    extends SelectionAdapter {
        protected UseEditorSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            String s = "<ERROR: retrieving query from editor>";
            HQueryDialog.this.queryField.setEditable(false);
            IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (part instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)part;
                s = HQueryDialog.QUERY_IS_EDITOR + editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get();
            } else {
                s = "<ERROR: selected editor is not a Text editor>";
            }
            HQueryDialog.this.queryField.setText(s);
            if (s.startsWith(HQueryDialog.QUERY_IS_EDITOR)) {
                HQueryDialog.this.queryField.setStyleRange(HQueryDialog.this.createBoldRange(HQueryDialog.QUERY_IS_EDITOR.length()));
            } else {
                HQueryDialog.this.queryField.setStyleRange(HQueryDialog.this.createBoldRange(s.length()));
            }
        }
    }
}

