/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.parser;

import gololang.Messages;
import org.eclipse.golo.compiler.parser.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected static String EOL = System.getProperty("line.separator", "\n");
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(ParseException.initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal));
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    private static String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        for (int[] expectedTokenSequence : expectedTokenSequences) {
            if (maxSize < expectedTokenSequence.length) {
                maxSize = expectedTokenSequence.length;
            }
            for (int j = 0; j < expectedTokenSequence.length; ++j) {
                expected.append(tokenImage[expectedTokenSequence[j]]).append(' ');
            }
            if (expectedTokenSequence[expectedTokenSequence.length - 1] != 0) {
                expected.append("...");
            }
            expected.append(EOL).append("    ");
        }
        StringBuilder retval = new StringBuilder(Messages.message("unexpected_token"));
        Token tok = currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval.append(" ");
            }
            if (tok.kind == 0) {
                retval.append(tokenImage[0]);
                break;
            }
            retval.append(" ").append(tokenImage[tok.kind]);
            retval.append(" `").append(ParseException.addEscapes(tok.image)).append("` ");
            tok = tok.next;
        }
        retval.append(Messages.message("source_position", currentToken.next.beginLine, currentToken.next.beginColumn));
        return retval.toString();
    }

    static String addEscapes(String str) {
        StringBuffer retval = new StringBuffer();
        block10: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\b': {
                    retval.append("\\b");
                    continue block10;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block10;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block10;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block10;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block10;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block10;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block10;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

