/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;

public final class SymbolGenerator {
    public static final String PREFIX = "__$$_";
    public static final String DEFAULT_NAME = "symbol";
    public static final String ESCAPE_MANGLE = "$";
    public static final String JOIN = "_";
    private final AtomicLong counter = new AtomicLong();
    private final Deque<String> prefixes = new LinkedList<String>();

    public SymbolGenerator(String name) {
        this.prefixes.addLast(name == null ? DEFAULT_NAME : name.replace('.', '$'));
    }

    public SymbolGenerator() {
        this.prefixes.addLast(DEFAULT_NAME);
    }

    private String name(String localName, long idx) {
        return this.name((localName == null || "".equals(localName) ? "" : localName + JOIN) + idx);
    }

    private String name(String localName) {
        String name = PREFIX + String.join((CharSequence)JOIN, this.prefixes);
        if (localName != null && !"".equals(localName)) {
            name = name + JOIN + localName;
        }
        return name;
    }

    public String next() {
        return this.next(null);
    }

    public String next(String name) {
        return this.name(name, this.counter.incrementAndGet());
    }

    public String getFor(String localName) {
        if (localName.startsWith(ESCAPE_MANGLE)) {
            return localName.substring(ESCAPE_MANGLE.length());
        }
        return this.name(localName);
    }

    public String current(String name) {
        return this.name(name, this.counter.get());
    }

    public String current() {
        return this.name(null, this.counter.get());
    }

    public SymbolGenerator exit() {
        if (this.prefixes.size() > 1) {
            this.prefixes.removeLast();
        }
        return this;
    }

    public SymbolGenerator enter(String scopeName) {
        this.prefixes.addLast(scopeName.replace('.', '$'));
        return this;
    }
}

