/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import java.util.Objects;

public class PositionInSourceCode {
    private final int startLine;
    private final int startColumn;
    private final int endLine;
    private final int endColumn;
    private static final PositionInSourceCode UNDEFINED = new PositionInSourceCode(0, 0, 0, 0){

        @Override
        public boolean isUndefined() {
            return true;
        }

        @Override
        public String toString() {
            return "undefined";
        }
    };

    private PositionInSourceCode(int startLine, int startColumn, int endLine, int endColumn) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
    }

    public static PositionInSourceCode undefined() {
        return UNDEFINED;
    }

    public static PositionInSourceCode of(PositionInSourceCode pos) {
        if (pos == null) {
            return UNDEFINED;
        }
        return pos;
    }

    public static PositionInSourceCode of(int line, int column) {
        return PositionInSourceCode.of(line, column, line, column);
    }

    public static PositionInSourceCode of(int startLine, int startColumn, int endLine, int endColumn) {
        if (startLine <= 0 && endLine <= 0 && startColumn <= 0 && endColumn <= 0) {
            return UNDEFINED;
        }
        return new PositionInSourceCode(startLine, startColumn, endLine, endColumn);
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public boolean isUndefined() {
        return false;
    }

    public String toString() {
        if (this.startLine == this.endLine && this.startColumn == this.endColumn) {
            return String.format("{line=%d, column=%d}", this.startLine, this.startColumn);
        }
        return String.format("{from=%d;%d, to=%d;%d}", this.startLine, this.startColumn, this.endLine, this.endColumn);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PositionInSourceCode that = (PositionInSourceCode)o;
        return this.startColumn == that.startColumn && this.startLine == that.startLine && this.endLine == that.endLine && this.endColumn == that.endColumn;
    }

    public int hashCode() {
        return Objects.hash(this.startLine, this.startColumn, this.endLine, this.endColumn);
    }
}

