/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import gololang.ir.GoloElement;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

final class JavaBytecodeUtils {
    private static final int[] ICONST = new int[]{2, 3, 4, 5, 6, 7, 8};

    private JavaBytecodeUtils() {
    }

    static boolean between(int value, int lower, int upper) {
        return value >= lower && value <= upper;
    }

    static void loadInteger(MethodVisitor methodVisitor, int value) {
        if (JavaBytecodeUtils.between(value, Short.MIN_VALUE, Short.MAX_VALUE)) {
            if (JavaBytecodeUtils.between(value, -128, 127)) {
                if (JavaBytecodeUtils.between(value, -1, 5)) {
                    methodVisitor.visitInsn(ICONST[value + 1]);
                } else {
                    methodVisitor.visitIntInsn(16, value);
                }
            } else {
                methodVisitor.visitIntInsn(17, value);
            }
        } else {
            methodVisitor.visitLdcInsn((Object)value);
        }
    }

    static void loadLong(MethodVisitor methodVisitor, long value) {
        if (value == 0L) {
            methodVisitor.visitInsn(9);
        } else if (value == 1L) {
            methodVisitor.visitInsn(10);
        } else {
            methodVisitor.visitLdcInsn((Object)value);
        }
    }

    static Label visitLine(GoloElement<?> element, MethodVisitor visitor) {
        Label label = new Label();
        visitor.visitLabel(label);
        if (element.hasPosition()) {
            visitor.visitLineNumber(element.positionInSourceCode().getStartLine(), label);
        }
        return label;
    }
}

