/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.FunctionReference;
import gololang.ir.AssignmentStatement;
import gololang.ir.Augmentation;
import gololang.ir.BinaryOperation;
import gololang.ir.Block;
import gololang.ir.CaseStatement;
import gololang.ir.ClosureReference;
import gololang.ir.CollectionComprehension;
import gololang.ir.CollectionLiteral;
import gololang.ir.ConditionalBranching;
import gololang.ir.ConstantStatement;
import gololang.ir.Decorator;
import gololang.ir.DestructuringAssignment;
import gololang.ir.ForEachLoopStatement;
import gololang.ir.FunctionInvocation;
import gololang.ir.GoloElement;
import gololang.ir.GoloFunction;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloModule;
import gololang.ir.LocalReference;
import gololang.ir.LoopBreakFlowStatement;
import gololang.ir.LoopStatement;
import gololang.ir.MatchExpression;
import gololang.ir.Member;
import gololang.ir.MethodInvocation;
import gololang.ir.ModuleImport;
import gololang.ir.NamedArgument;
import gololang.ir.NamedAugmentation;
import gololang.ir.Noop;
import gololang.ir.ReferenceLookup;
import gololang.ir.ReturnStatement;
import gololang.ir.Struct;
import gololang.ir.ThrowStatement;
import gololang.ir.ToplevelElements;
import gololang.ir.TryCatchFinally;
import gololang.ir.UnaryOperation;
import gololang.ir.Union;
import gololang.ir.UnionValue;
import gololang.ir.WhenClause;
import java.util.Map;
import java.util.function.BiFunction;

public final class Visitors {
    private Visitors() {
        throw new UnsupportedOperationException();
    }

    public static GoloIrVisitor visitor(Map<Class<? extends GoloElement<?>>, FunctionReference> functions) {
        return Visitors.visitor(functions, null, Walk.PREFIX);
    }

    public static DispatchIrVisitor visitor(final Map<Class<? extends GoloElement<?>>, FunctionReference> functions, final FunctionReference defaultFunction, Walk walk) {
        return new DispatchIrVisitor(walk){

            @Override
            protected FunctionReference dispatchFunction(GoloElement<?> elt) {
                return functions.getOrDefault(elt.getClass(), defaultFunction);
            }
        };
    }

    public static DispatchIrVisitor visitor(final FunctionReference fun, Walk walk) {
        return new DispatchIrVisitor(walk){

            @Override
            protected FunctionReference dispatchFunction(GoloElement<?> elt) {
                return fun;
            }
        };
    }

    public static GoloIrVisitor visitor(FunctionReference function) {
        return Visitors.visitor(function, Walk.PREFIX);
    }

    public static abstract class DispatchIrVisitor
    implements GoloIrVisitor,
    BiFunction<Object, GoloElement<?>, Object> {
        private Object accumulator;
        private Walk walk;

        protected abstract FunctionReference dispatchFunction(GoloElement<?> var1);

        private void dispatch(GoloElement<?> elt) {
            FunctionReference f;
            if (this.walk == Walk.PREFIX || this.walk == Walk.BOTH) {
                elt.walk(this);
            }
            if ((f = this.dispatchFunction(elt)) != null) {
                try {
                    switch (f.arity()) {
                        case 1: {
                            this.accumulator = f.invoke(elt);
                            break;
                        }
                        case 2: {
                            this.accumulator = f.invoke(this.accumulator, elt);
                            break;
                        }
                        case 3: {
                            Object result = f.invoke(this, this.accumulator, elt);
                            if (result != null) {
                                this.accumulator = result;
                            }
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("The dispatched function must have an arity of 1, 2 or 3");
                        }
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            if (this.walk == Walk.POSTFIX || this.walk == Walk.BOTH) {
                elt.walk(this);
            }
        }

        private DispatchIrVisitor(Walk walk) {
            this.walk = walk;
        }

        public Object accumulator() {
            return this.accumulator;
        }

        public DispatchIrVisitor accumulator(Object acc) {
            this.accumulator = acc;
            return this;
        }

        @Override
        public Object apply(Object acc, GoloElement<?> elt) {
            this.accumulator(acc);
            elt.accept(this);
            return this.accumulator();
        }

        @Override
        public void visitModule(GoloModule elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitModuleImport(ModuleImport elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitStruct(Struct elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitUnion(Union elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitUnionValue(UnionValue elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitAugmentation(Augmentation elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitNamedAugmentation(NamedAugmentation elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitFunction(GoloFunction elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitDecorator(Decorator elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitBlock(Block elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitConstantStatement(ConstantStatement elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitReturnStatement(ReturnStatement elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitFunctionInvocation(FunctionInvocation elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitMethodInvocation(MethodInvocation elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitAssignmentStatement(AssignmentStatement elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitDestructuringAssignment(DestructuringAssignment elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitReferenceLookup(ReferenceLookup elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitConditionalBranching(ConditionalBranching elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitBinaryOperation(BinaryOperation elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitUnaryOperation(UnaryOperation elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitLoopStatement(LoopStatement elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitForEachLoopStatement(ForEachLoopStatement elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitCaseStatement(CaseStatement elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitMatchExpression(MatchExpression elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitWhenClause(WhenClause<?> elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitThrowStatement(ThrowStatement elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitTryCatchFinally(TryCatchFinally elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitClosureReference(ClosureReference elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitLoopBreakFlowStatement(LoopBreakFlowStatement elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitCollectionLiteral(CollectionLiteral elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitCollectionComprehension(CollectionComprehension elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitNamedArgument(NamedArgument elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitLocalReference(LocalReference elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitMember(Member elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitNoop(Noop elt) {
            this.dispatch(elt);
        }

        @Override
        public void visitToplevelElements(ToplevelElements elt) {
            this.dispatch(elt);
        }
    }

    static enum Walk {
        PREFIX,
        POSTFIX,
        BOTH,
        NONE;

    }
}

