/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import java.util.Objects;

public final class Member
extends GoloElement<Member> {
    private final String name;

    private Member(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public static Member of(Object o) {
        if (o instanceof Member) {
            return (Member)o;
        }
        return new Member(o.toString());
    }

    @Override
    protected Member self() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPublic() {
        return !this.name.startsWith("_");
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitMember(this);
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        throw this.cantReplace(original, newElement);
    }

    public String toString() {
        return String.format("<%s>", this.name);
    }
}

