/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.AssignmentStatement;
import gololang.ir.Block;
import gololang.ir.BlockContainer;
import gololang.ir.ConstantStatement;
import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloStatement;
import gololang.ir.LocalReference;
import gololang.ir.ReferencesHolder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class LoopStatement
extends GoloStatement<LoopStatement>
implements BlockContainer<LoopStatement>,
ReferencesHolder {
    private AssignmentStatement initStatement = null;
    private ExpressionStatement<?> conditionStatement = null;
    private GoloStatement<?> postStatement = null;
    private Block block = null;

    private LoopStatement() {
    }

    public static LoopStatement loop() {
        return new LoopStatement().condition(null).block(null);
    }

    public static LoopStatement create(Object init, Object condition, Object post, Object block) {
        return LoopStatement.loop().init(init).condition(condition).post(post).block(Block.of(block));
    }

    @Override
    protected LoopStatement self() {
        return this;
    }

    public LoopStatement init(Object assignment) {
        if (assignment instanceof AssignmentStatement) {
            this.initStatement = this.makeParentOf((AssignmentStatement)assignment);
            return this;
        }
        if (assignment == null) {
            this.initStatement = null;
            return this;
        }
        throw LoopStatement.cantConvert("assignment", assignment);
    }

    public LoopStatement condition(Object expression) {
        if (expression == null) {
            this.conditionStatement = ConstantStatement.of(false);
        } else if (expression instanceof ExpressionStatement) {
            this.conditionStatement = ExpressionStatement.of(expression);
        } else {
            throw LoopStatement.cantConvert("expression", expression);
        }
        this.makeParentOf(this.conditionStatement);
        return this;
    }

    public LoopStatement post(Object statement) {
        if (statement instanceof GoloStatement) {
            this.postStatement = this.makeParentOf((GoloStatement)statement);
            return this;
        }
        if (statement == null) {
            this.postStatement = null;
            return this;
        }
        throw LoopStatement.cantConvert("statement", statement);
    }

    @Override
    public LoopStatement block(Object innerBlock) {
        this.block = this.makeParentOf(Block.of(innerBlock));
        return this;
    }

    public boolean hasInitStatement() {
        return this.initStatement != null;
    }

    public AssignmentStatement init() {
        return this.initStatement;
    }

    public ExpressionStatement<?> condition() {
        return this.conditionStatement;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    public GoloStatement<?> post() {
        return this.postStatement;
    }

    public boolean hasPostStatement() {
        return this.postStatement != null;
    }

    @Override
    public LocalReference[] getReferences() {
        if (this.hasInitStatement()) {
            return new LocalReference[]{this.init().getLocalReference()};
        }
        return new LocalReference[0];
    }

    @Override
    public int getReferencesCount() {
        return this.hasInitStatement() ? 1 : 0;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitLoopStatement(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        LinkedList children = new LinkedList();
        if (this.initStatement != null) {
            children.add(this.initStatement);
        }
        if (this.conditionStatement != null) {
            children.add(this.conditionStatement);
        }
        if (this.postStatement != null) {
            children.add(this.postStatement);
        }
        if (this.block != null) {
            children.add(this.block);
        }
        return children;
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (Objects.equals(this.initStatement, original)) {
            this.init(newElement);
        } else if (Objects.equals(this.conditionStatement, original)) {
            this.condition(newElement);
        } else if (Objects.equals(this.postStatement, original)) {
            this.post(newElement);
        } else if (Objects.equals(this.block, original)) {
            this.block(Block.of(newElement));
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

