/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.FunctionReference;
import gololang.ir.AbstractGoloIrVisitor;
import gololang.ir.Block;
import gololang.ir.ClosureReference;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloModule;
import gololang.ir.ReferenceTable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.golo.compiler.PositionInSourceCode;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public abstract class GoloElement<T extends GoloElement<T>> {
    private GoloElement<?> parent;
    private String documentation;
    private PositionInSourceCode position;
    private final Map<String, Object> meta = new HashMap<String, Object>();

    protected abstract T self();

    public final T ofAST(GoloASTNode node) {
        if (node != null) {
            this.documentation(node.getDocumentation());
            this.positionInSourceCode(node.getPositionInSourceCode());
        }
        return this.self();
    }

    private void setParentNode(GoloElement<?> parentElement) {
        this.parent = parentElement;
    }

    public final boolean hasParent() {
        return this.parent != null && this.parent != this;
    }

    public final GoloElement<?> parent() {
        return this.parent;
    }

    public GoloModule enclosingModule() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.enclosingModule();
    }

    public <C extends GoloElement<?>> C ancestorOfType(Class<C> cls) {
        return (C)((GoloElement)cls.cast(this.ancestor(cls::isInstance)));
    }

    public GoloElement<?> ancestor(Predicate<GoloElement<?>> predicate) {
        if (this.parent == null) {
            return null;
        }
        if (predicate.test(this.parent)) {
            return this.parent;
        }
        if (this.parent == this) {
            return null;
        }
        return this.parent.ancestor(predicate);
    }

    public GoloElement<?> ancestor(FunctionReference predicate) {
        return this.ancestor(GoloElement.predicateWrapper(predicate));
    }

    public List<GoloElement<?>> descendants(Predicate<GoloElement<?>> predicate) {
        return this.descendants().filter(predicate).collect(Collectors.toList());
    }

    public List<GoloElement<?>> descendants(FunctionReference predicate) {
        return this.descendants(GoloElement.predicateWrapper(predicate));
    }

    public Stream<GoloElement<?>> descendants() {
        return Stream.concat(this.children().stream(), this.children().stream().flatMap(GoloElement::descendants));
    }

    private static Predicate<GoloElement<?>> predicateWrapper(FunctionReference predicate) {
        return n -> {
            try {
                return (Boolean)predicate.invoke(n);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    public List<GoloElement<?>> children() {
        return Collections.emptyList();
    }

    public List<GoloElement<?>> children(Predicate<GoloElement<?>> predicate) {
        return this.children().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<GoloElement<?>> children(FunctionReference predicate) {
        return this.children(GoloElement.predicateWrapper(predicate));
    }

    public GoloElement<?> previous() {
        return this.previous((GoloElement<?> e) -> true);
    }

    public GoloElement<?> previous(Predicate<GoloElement<?>> predicate) {
        if (this.parent == null || this.parent == this) {
            return null;
        }
        GoloElement<?> previous = null;
        for (GoloElement<?> e : this.parent.children()) {
            if (e == this) break;
            if (!predicate.test(e)) continue;
            previous = e;
        }
        return previous;
    }

    public GoloElement<?> previous(FunctionReference predicate) {
        return this.previous(GoloElement.predicateWrapper(predicate));
    }

    public GoloElement<?> next() {
        return this.next((GoloElement<?> e) -> true);
    }

    public GoloElement<?> next(FunctionReference predicate) {
        return this.next(GoloElement.predicateWrapper(predicate));
    }

    public GoloElement<?> next(Predicate<GoloElement<?>> predicate) {
        if (this.parent == null || this.parent == this) {
            return null;
        }
        boolean found = false;
        for (GoloElement<?> e : this.parent.children()) {
            if (found && predicate.test(e)) {
                return e;
            }
            if (e != this) continue;
            found = true;
        }
        return null;
    }

    protected final <C extends GoloElement<?>> C makeParentOf(C childElement) {
        if (childElement != null && childElement.parent() != this) {
            super.setParentNode(this);
            this.relinkChild(childElement);
        }
        return childElement;
    }

    private void relinkChild(GoloElement<?> child) {
        this.getLocalReferenceTable().ifPresent(rt -> child.accept(new RelinkIrVisitor((ReferenceTable)rt)));
    }

    public final Object metadata(String name) {
        return this.meta.get(name);
    }

    public final T metadata(String name, Object value) {
        if (value == null) {
            this.meta.remove(name);
        } else {
            this.meta.put(name, value);
        }
        return this.self();
    }

    protected final RuntimeException cantReplace() {
        return new UnsupportedOperationException(this.getClass().getName() + " can't replace elements");
    }

    protected final RuntimeException cantReplace(GoloElement<?> original, GoloElement<?> replacement) {
        return new IllegalArgumentException(this + " can't replace " + original + " with " + replacement);
    }

    protected final RuntimeException doesNotContain(GoloElement<?> element) {
        return new NoSuchElementException(element + " not in " + this);
    }

    protected static final RuntimeException cantConvert(String expected, Object value) {
        return new ClassCastException(String.format("expecting a %s but got a %s", expected, value == null ? "null value" : value.getClass().getName()));
    }

    public final void replaceInParentBy(GoloElement<?> newElement) {
        if (newElement == this) {
            return;
        }
        if (this.parent != null) {
            this.parent.replaceElement(this, newElement);
            this.parent.makeParentOf(newElement);
            if (newElement.position == null) {
                newElement.position = this.position;
            }
            if (newElement.documentation == null || newElement.documentation.isEmpty()) {
                newElement.documentation = this.documentation;
            }
        } else {
            throw new IllegalStateException("This node has no parent");
        }
        this.setParentNode(null);
    }

    public final String documentation() {
        return this.documentation;
    }

    public final T documentation(String doc) {
        if (doc != null) {
            this.documentation = doc;
        }
        return this.self();
    }

    public final PositionInSourceCode positionInSourceCode() {
        if (this.position == null && this.parent != null) {
            return this.parent.positionInSourceCode();
        }
        return PositionInSourceCode.of(this.position);
    }

    public final T positionInSourceCode(PositionInSourceCode pos) {
        this.position = pos != null && pos.isUndefined() ? null : pos;
        return this.self();
    }

    public final boolean hasPosition() {
        return this.position != null || this.parent != null && this.parent != this && this.parent.hasPosition();
    }

    public Optional<ReferenceTable> getLocalReferenceTable() {
        if (this.hasParent()) {
            return this.parent.getLocalReferenceTable();
        }
        return Optional.empty();
    }

    public abstract void accept(GoloIrVisitor var1);

    public void walk(GoloIrVisitor visitor) {
        for (GoloElement<?> e : this.children()) {
            e.accept(visitor);
        }
    }

    protected abstract void replaceElement(GoloElement<?> var1, GoloElement<?> var2);

    private static class RelinkIrVisitor
    extends AbstractGoloIrVisitor {
        private final ReferenceTable rt;
        boolean prune;

        RelinkIrVisitor(ReferenceTable rt) {
            this.rt = rt;
            this.prune = true;
        }

        @Override
        public void visitBlock(Block b) {
            b.getReferenceTable().relink(this.rt, this.prune);
        }

        @Override
        public void visitClosureReference(ClosureReference c) {
            this.prune = false;
            c.walk(this);
        }
    }
}

