/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.GoloAssignment;
import gololang.ir.GoloIrVisitor;
import gololang.ir.LocalReference;
import java.util.LinkedList;
import java.util.List;

public final class DestructuringAssignment
extends GoloAssignment<DestructuringAssignment> {
    private final List<LocalReference> references = new LinkedList<LocalReference>();
    private boolean isVarargs = false;

    private DestructuringAssignment() {
    }

    public static DestructuringAssignment destruct(Object expr) {
        return (DestructuringAssignment)new DestructuringAssignment().as(expr);
    }

    public static DestructuringAssignment create() {
        return new DestructuringAssignment();
    }

    @Override
    protected DestructuringAssignment self() {
        return this;
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }

    public DestructuringAssignment varargs(boolean varargs) {
        this.isVarargs = varargs;
        return this;
    }

    public DestructuringAssignment varargs() {
        return this.varargs(true);
    }

    @Override
    public DestructuringAssignment variable() {
        for (LocalReference ref : this.references) {
            ref.variable();
        }
        return this;
    }

    @Override
    public boolean isConstant() {
        if (!this.references.isEmpty()) {
            return this.references.get(0).isConstant();
        }
        return false;
    }

    @Override
    public LocalReference[] getReferences() {
        return this.references.toArray(new LocalReference[this.references.size()]);
    }

    @Override
    public int getReferencesCount() {
        return this.references.size();
    }

    @Override
    public DestructuringAssignment to(Object ... refs) {
        for (Object o : refs) {
            this.references.add(LocalReference.of(o));
        }
        return this;
    }

    public String toString() {
        LinkedList<String> names = new LinkedList<String>();
        for (LocalReference r : this.getReferences()) {
            names.add(r.toString());
        }
        return String.join((CharSequence)", ", names) + " = " + this.expression().toString();
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitDestructuringAssignment(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (LocalReference ref : this.references) {
            ref.accept(visitor);
        }
        super.walk(visitor);
    }
}

