/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.Messages;
import gololang.ir.ClassReference;
import gololang.ir.ExpressionStatement;
import gololang.ir.FunctionRef;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;

public final class ConstantStatement
extends ExpressionStatement<ConstantStatement> {
    private Object value;

    private ConstantStatement(Object value) {
        this.value = value;
    }

    public static ConstantStatement of(Object o) {
        if (o instanceof ConstantStatement) {
            return (ConstantStatement)o;
        }
        if (o instanceof Class || o instanceof ClassReference) {
            return new ConstantStatement(ClassReference.of(o));
        }
        if (!ConstantStatement.isLiteralValue(o)) {
            throw new IllegalArgumentException("Not a constant value: " + o);
        }
        return new ConstantStatement(o);
    }

    public static boolean isLiteralValue(Object v) {
        return v == null || v instanceof String || v instanceof Character || v instanceof Number || v instanceof Boolean || v instanceof Class || v instanceof ClassReference || v instanceof FunctionRef;
    }

    public Object value() {
        return this.value;
    }

    public ConstantStatement value(Object v) {
        this.value = v;
        return this;
    }

    @Override
    protected ConstantStatement self() {
        return this;
    }

    @Override
    public ConstantStatement with(Object a) {
        throw new UnsupportedOperationException(Messages.message("invalid_local_definition", this.getClass().getName()));
    }

    @Override
    public boolean hasLocalDeclarations() {
        return false;
    }

    public String toString() {
        return String.format("`%s`", this.value);
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitConstantStatement(this);
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        throw this.cantReplace();
    }
}

