/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.Block;
import gololang.ir.BlockContainer;
import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloFunction;
import gololang.ir.GoloIrVisitor;
import java.util.Collection;
import java.util.List;

public class ClosureReference
extends ExpressionStatement<ClosureReference>
implements BlockContainer<ClosureReference> {
    private GoloFunction target;

    ClosureReference(GoloFunction target) {
        this.setTarget(target);
    }

    @Override
    protected ClosureReference self() {
        return this;
    }

    public GoloFunction getTarget() {
        return this.target;
    }

    private void setTarget(GoloFunction target) {
        this.target = this.makeParentOf(target);
        this.positionInSourceCode(target.positionInSourceCode());
        this.documentation(target.documentation());
    }

    public Collection<String> getCapturedReferenceNames() {
        return this.target.getSyntheticParameterNames();
    }

    public boolean hasCapturedReferences() {
        return this.target.getSyntheticParameterCount() > 0;
    }

    @Override
    public ClosureReference body(Object ... statements) {
        this.target.body(statements);
        return this;
    }

    @Override
    public ClosureReference block(Object block) {
        this.target.block(block);
        return this;
    }

    @Override
    public Block getBlock() {
        return this.target.getBlock();
    }

    public ClosureReference returns(Object expression) {
        this.target.returns(expression);
        return this;
    }

    public ClosureReference varargs() {
        this.target.varargs();
        return this;
    }

    public ClosureReference varargs(boolean v) {
        this.target.varargs(v);
        return this;
    }

    public boolean isVarargs() {
        return this.target.isVarargs();
    }

    public ClosureReference withParameters(Collection<String> paramNames) {
        this.target.withParameters(paramNames);
        return this;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitClosureReference(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.target.accept(visitor);
    }

    @Override
    public List<GoloElement<?>> children() {
        return this.target.children();
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!(newElement instanceof GoloFunction) || !this.target.equals(original)) {
            throw this.cantReplace(original, newElement);
        }
        this.setTarget((GoloFunction)newElement);
    }

    public String toString() {
        return String.format("ClosureReference{target=%s, captured=%s}", this.target, this.getCapturedReferenceNames());
    }
}

